package com.biz.crm.mdm.business.org.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.feign.feign.internal.OrgPositionVoFeignImpl;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 组织基本信息feign
 * @author pengxi
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = OrgPositionVoFeignImpl.class)
public interface OrgPositionVoFeign {

  /**
   * 根据职位查询组织信息
   *
   * @param positionCode 岗位编码
   * @return Result<OrgVo>
   */
  @ApiOperation(value = "根据职位查询组织信息")
  @PostMapping(value = "/v1/org/position/findByPositionCode")
  public Result<OrgVo> findByPositionCode(@RequestParam("positionCode") String positionCode);

  /**
   * 根据组织编码查询组织职位集合
   *
   * @param orgCodes 组织机构编码
   * @return 组织职位集合
   */
  @GetMapping(value = {"/v1/org/position/findByOrgCodes"})
  Result<List<OrgPositionVo>> findByOrgCodes(@RequestParam("orgCodes") List<String> orgCodes);

  /**
   * 根据职位集合查询组织编码集合
   *
   * @param positionCodes 职位集合
   * @return 组织职位关联信息集合
   */
  @ApiOperation(value = "根据职位集合查询组织编码集合")
  @GetMapping(value = {"/v1/org/position/findByPositionCodes"})
  Result<List<OrgPositionVo>> findByPositionCodes(@RequestParam("positionCodes") List<String> positionCodes);
}