package com.biz.crm.mdm.business.org.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.feign.feign.OrgVoFeign;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: 组织行基本信息feign熔断实现
 * @description:
 * @author: Bao Hongbin
 * @create: 2021-11-24 11:22
 */
@Component
public class OrgVoFeignImpl implements FallbackFactory<OrgVoFeign> {

  @Override
  public OrgVoFeign create(Throwable throwable) {
    return new OrgVoFeign() {

      @Override
      public Result<List<OrgVo>> findAllParentByOrgCode(String orgCode) {
        throw new UnsupportedOperationException("根据组织编码查询全部上级（含当前）组织列表熔断");
      }

      @Override
      public Result<List<OrgVo>> findByOrgCodes(List<String> orgCodeList) {
        throw new UnsupportedOperationException("按orgCode集合查询熔断");
      }

      @Override
      public Result<List<OrgVo>> findAllParentByOrgCodes(List<String> orgCodes) {
        throw new UnsupportedOperationException("根据组织编码集合查询全部上级（含当前）组织列表熔断");
      }

      @Override
      public Result<List<OrgVo>> findAllChildrenByOrgCode(String orgCode) {
        throw new UnsupportedOperationException("根据组织编码查询下级组织列表熔断");
      }

      @Override
      public Result<Set<String>> findByOrgQueryDto(OrgQueryDto dto) {
        throw new UnsupportedOperationException("获取组织编码熔断");
      }

      @Override
      public Result<Map<String,String>> findByRelateOrgCodeQueryDto(RelateOrgCodeQueryDto dto) {
        throw new UnsupportedOperationException("根据获取组织对应的未删除的上级或下级编码熔断");
      }
    };
  }
}
