package com.biz.crm.mdm.business.org.local.authority;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import org.springframework.stereotype.Component;

/**
 * @Author: heguanyun
 * @Date: 2022/4/7 10:11 description:匹配当前登录者/操作者所属组织
 */
@Component("orgSelectAuthorityModeRegister")
public class OrgAuthorityModeRegister implements SelectAuthorityModeRegister {
  @Override
  public String modeKey() {
    return "orgAuthorityModeRegister";
  }

  @Override
  public String modeName() {
    return "按照当前登录者/操作者所属组织进行组织维度的值确认";
  }

  @Override
  public String controlKey() {
    return "orgAuthorityModeRegister";
  }

  @Override
  public int sort() {
    return 3;
  }

  @Override
  public String groupCode() {
    return "org_group";
  }

  @Override
  public String converterKey() {
    return "chartEqualMarsAuthorityValueAstConverter";
  }

  @Override
  public boolean isArrayValue() {
    return false;
  }

  @Override
  public boolean isStaticValue() {
    return false;
  }

  @Override
  public Class<?> modeValueClass() {
    return String.class;
  }

  @Override
  public Object staticValue(String[] staticValues) {
    return null;
  }

  @Override
  public Object dynamicValue(LoginDetails loginDetails, String modeGroupCode) {
    //如果不是后台管理用户，就不组织位字段进行权限控制
    if (!(loginDetails instanceof LoginUserDetails)) {
      return null;
    }
    LoginUserDetails loginUserDetails = (LoginUserDetails) loginDetails;
    return loginUserDetails.getOrgCode();
  }
}
