package com.biz.crm.mdm.business.org.local.authority;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * @Author: heguanyun
 * @Date: 2022/4/6 17:46 description:按照当前组织配置展示规则
 */
@Component("orgScopeRegister")
public class OrgScopeRegister implements SelectScopeRegister {
  @Override
  public String scopeKey() {
    return "org_scope";
  }

  @Override
  public String selectName() {
    return "当前组织";
  }

  @Override
  public String controlKey() {
    return "org_tree";
  }

  @Override
  public String controlName() {
    return "组织选择树";
  }

  /**
   * 判断是否启用该校验
   *
   * @param loginDetails
   * @param scopeValues
   * @return
   */
  @Override
  public boolean matched(LoginDetails loginDetails, String[] scopeValues) {
    if (scopeValues == null || scopeValues.length == 0) {
      return false;
    }
    // 如果不是后台管理用户，就不按职位进行权限控制
    if (!(loginDetails instanceof LoginUserDetails)) {
      return false;
    }
    LoginUserDetails loginUserDetails = (LoginUserDetails) loginDetails;
    Set<String> scopeSet = new HashSet<>(Arrays.asList(scopeValues));
    return scopeSet.contains(loginUserDetails.getOrgCode());
  }
}
