package com.biz.crm.mdm.business.org.local.authority;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Author: heguanyun
 * @Date: 2022/4/7 14:51 description:按照当前及下级组织
 */
@Lazy
@Component("orgTreeScopeRegister")
public class OrgTreeScopeRegister implements SelectScopeRegister {
  @Autowired(required = false)
  private ApplicationContext applicationContext;
  @Override
  public String scopeKey() {
    return "org_tree_scope";
  }

  @Override
  public String selectName() {
    return "当前及下级组织";
  }

  @Override
  public String controlKey() {
    return "org_tree";
  }

  @Override
  public String controlName() {
    return "组织选择树";
  }

  @Override
  public boolean matched(LoginDetails loginDetails, String[] scopeValues) {
    OrgService orgService = applicationContext.getBean(OrgService.class);
    if (scopeValues == null || scopeValues.length == 0) {
      return false;
    }
    // 如果不是后台管理用户，就不按职位进行权限控制
    if (!(loginDetails instanceof LoginUserDetails)) {
      return false;
    }
    LoginUserDetails loginUserDetails = (LoginUserDetails) loginDetails;
    List<String> orgCodes = Arrays.asList(scopeValues);
    // 如果当前登录人所属组织恰好是选择的组织
    if (orgCodes.contains(loginUserDetails.getOrgCode())) {
      return true;
    }
    // 校验当前登录人所属组织是否为选择组织的下级组织
    List<Org> children = orgService.findAllChildrenByOrgCodes(orgCodes);
    if (CollectionUtils.isEmpty(children)) {
      return false;
    }
    Set<String> scopeSet = children.stream().map(Org::getOrgCode).collect(Collectors.toSet());
    return scopeSet.contains(loginUserDetails.getOrgCode());
  }
}
