package com.biz.crm.mdm.business.org.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author sunx
 * @date 2021/11/22
 */
@Api(tags = "组织信息: OrgVo: 组织信息")
@Slf4j
@RestController
@RequestMapping(value = {"/v1/org/org"})
public class OrgVoController {

  @Autowired(required = false)
  private OrgVoService orgVoService;

  /**
   * 按orgCode集合查询
   *
   * @param orgCodeList
   * @return
   */
  @GetMapping(value = {"/findByOrgCodes"})
  public Result<List<OrgVo>> findByOrgCodes(@RequestParam("orgCodeList") List<String> orgCodeList) {
    try {
      return Result.ok(this.orgVoService.findByOrgCodes(orgCodeList));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据 组织编码查询 全部上级（含当前）组织列表
   * @param orgCode
   * @return
   */
  @ApiOperation("根据 组织编码查询 全部上级（含当前）组织列表")
  @GetMapping("/findAllParentByOrgCode")
  public Result<List<OrgVo>> findAllParentByIdOrOrgCode(@RequestParam("orgCode") String orgCode) {
    try {
      List<OrgVo> list = this.orgVoService.findAllParentByOrgCode(orgCode);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据 组织编码集合查询 全部上级（含当前）组织列表
   * @param orgCodes
   * @return
   */
  @ApiOperation("根据 组织编码集合查询 全部上级（含当前）组织列表")
  @GetMapping("/findAllParentByOrgCodes")
  public Result<List<OrgVo>> findAllParentByIdOrOrgCode(@RequestParam("orgCodes") List<String> orgCodes) {
    try {
      List<OrgVo> list = this.orgVoService.findAllParentByOrgCodes(orgCodes);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 查询指定orgCode下的所有子节点
   *
   * @param orgCode
   * @return
   */
  @ApiOperation("根据 组织编码集合查询 全部上级（含当前）组织列表")
  @GetMapping("/findAllChildrenByOrgCode")
  public Result<List<OrgVo>> findAllChildrenByOrgCode(@RequestParam("orgCode") String orgCode) {
    try {
      List<OrgVo> list = this.orgVoService.findAllChildrenByOrgCode(orgCode);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取组织编码
   *
   * @param dto
   * @return
   */
  @ApiOperation("获取组织编码")
  @GetMapping("/findByOrgQueryDto")
  public Result<Set<String>> findByOrgQueryDto(OrgQueryDto dto) {
    try {
      Set<String> set = this.orgVoService.findByOrgQueryDto(dto);
      return Result.ok(set);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据获取组织对应的未删除的上级或下级编码
   *
   * @param dto
   * @return
   */
  @ApiOperation("根据获取组织对应的未删除的上级或下级编码")
  @GetMapping("/findByRelateOrgCodeQueryDto")
  public Result<Map<String, String>> findByRelateOrgCodeQueryDto(RelateOrgCodeQueryDto dto) {
    try {
      return Result.ok(this.orgVoService.findByRelateOrgCodeQueryDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
