package com.biz.crm.mdm.business.org.local.service.internal;

import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.repository.OrgRepository;
import com.biz.crm.mdm.business.org.sdk.common.constant.OrgCodeConstant;
import com.biz.crm.mdm.business.org.sdk.service.OrgLazyTreeVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author hefan
 */
@Service
public class OrgLazyTreeVoServiceImpl implements OrgLazyTreeVoService {

  @Autowired(required = false)
  private OrgRepository orgRepository;
  @Autowired(required = false)
  private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

  @Override
  public List<LazyTreeVo> findByTreeDto(TreeDto treeDto) {
    List<LazyTreeVo> list = new ArrayList<>();
    String excludeRuleCode = "";
    if (StringUtils.isNotEmpty(treeDto.getExcludeCodeAndChildren())) {
      // 根据 orgCode 查询 mdm_org 的 ruleCode
      Org one = this.orgRepository.findByOrgCode(treeDto.getExcludeCodeAndChildren(), TenantUtils.getTenantCode());
      if (one != null) {
        excludeRuleCode = one.getRuleCode();
      }
    }
    if (!StringUtils.isEmpty(treeDto.getParentCode())) {
      //查询parentCode下一级 hefan: 启用状态, 只查询该编码下一级, 排除这个降维编码的下级
      List<LazyTreeVo> lazyTreeVos = this.orgRepository.findOrgLazyTreeList(treeDto.getEnableStatus(), null, treeDto.getParentCode(), null, null, excludeRuleCode, TenantUtils.getTenantCode());
      list.addAll(lazyTreeVos);
    } else if (!StringUtils.isEmpty(treeDto.getName())) {
      //模糊查询并构建成树
      //   hefan: 根据  【EnableStatus】 orgName模糊  查询orgCode ruleCode
      List<Org> likeList = this.orgRepository.findOrgCodeAndRuleCodeByEnableStatusOptAndOrgNameLike(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode());
      if (!CollectionUtils.isEmpty(likeList)) {
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Set<String> parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(OrgCodeConstant.RULE_CODE_LENGTH, likeList.stream().map(Org::getRuleCode).collect(Collectors.toList()));
        // hefan: 启用状态, 只查询这些降维编码, 排除这个降维编码的下级
        list.addAll(this.orgRepository.findOrgLazyTreeList(treeDto.getEnableStatus(), null, null, null, new ArrayList<>(parentRuleCodes), excludeRuleCode, TenantUtils.getTenantCode()));
      }
    } else {
      //查询第一层  hefan：启用状态，传true只查第一层， 排除这个降维编码的下级
      list.addAll(this.orgRepository.findOrgLazyTreeList(treeDto.getEnableStatus(), true, null, null, null, excludeRuleCode, TenantUtils.getTenantCode()));
    }
    if (!CollectionUtils.isEmpty(list)) {
      list.forEach(item -> item.setHasChild(BooleanEnum.TRUE.getNumStr().equalsIgnoreCase(String.valueOf(item.getHasChildFlag()))));
      return TreeUtil.generateLazyTreeByParentCode(list);
    }
    return new ArrayList<>();
  }
}
