package com.biz.crm.mdm.business.org.local.service.internal;

import com.biz.crm.mdm.business.org.local.entity.OrgPosition;
import com.biz.crm.mdm.business.org.local.repository.OrgPositionRepository;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 组织职位关系接口实现
 *
 * @author pengxi
 * @date 2021/11/23
 */
@Service
public class OrgPositionVoServiceImpl implements OrgPositionVoService {

  @Autowired(required = false)
  private OrgPositionRepository orgPositionRepository;

  @Autowired(required = false)
  private OrgVoService orgVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private OrgService orgService;

  @Override
  public OrgVo findByPositionCode(String positionCode) {
    List<OrgPosition> orgPositions = this.orgPositionRepository.findByPositionCode(positionCode, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(orgPositions)) {
      return null;
    }
    // 职位与组织开发实现上是多对多的关系，但是产品确定业务上一个职位只属于一个组织
    return this.orgVoService.findByOrgCode(orgPositions.get(0).getOrgCode());
  }

  @Override
  public Set<String> findPositionCodesByOrgCodes(List<String> orgCodes) {
    if (CollectionUtils.isEmpty(orgCodes)) {
      return new HashSet<>();
    }
    List<OrgPosition> byOrgCodes = this.orgPositionRepository.findByOrgCodes(orgCodes, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(byOrgCodes)) {
      return new HashSet<>();
    }
    return byOrgCodes.stream().map(OrgPosition::getPositionCode).collect(Collectors.toSet());
  }

  @Override
  public List<OrgPositionVo> findByPositionCodes(List<String> positionCodes) {
    if (CollectionUtils.isEmpty(positionCodes)) {
      return new ArrayList<>();
    }
    List<OrgPosition> byPositionCodes = this.orgPositionRepository.findByPositionCodes(positionCodes, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(byPositionCodes)) {
      return new ArrayList<>();
    }
    return (List<OrgPositionVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byPositionCodes, OrgPosition.class, OrgPositionVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public List<OrgPositionVo> findByOrgCodes(List<String> orgCodes) {
    if (CollectionUtils.isEmpty(orgCodes)) {
      return Lists.newLinkedList();
    }
    List<OrgPosition> byOrgCodes = this.orgPositionRepository.findByOrgCodes(orgCodes, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(byOrgCodes)) {
      return Lists.newLinkedList();
    }
    return (List<OrgPositionVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byOrgCodes, OrgPosition.class, OrgPositionVo.class, HashSet.class, ArrayList.class);
  }
}
