package com.biz.crm.mdm.business.org.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.repository.OrgRepository;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.common.constant.OrgCodeConstant;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author hecheng
 * @description: 组织vo serivce 实现
 * @date 2021/9/29 上午11:27
 */
@Service
public class OrgVoServiceImpl implements OrgVoService {

  @Autowired(required = false)
  private OrgService orgService;
  @Autowired(required = false)
  private OrgRepository orgRepository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

  @Override
  public Page<OrgVo> findByConditions(Pageable pageable, OrgPaginationDto paginationDto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (paginationDto == null) {
      paginationDto = new OrgPaginationDto();
    }
    Page<Org> page = this.orgService.findByConditions(pageable, paginationDto);
    Page<OrgVo> pageVo = new Page<>();
    if (Objects.isNull(page)) {
      return null;
    }
    if (CollectionUtils.isNotEmpty(page.getRecords())) {
      List<OrgVo> vos = (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(page.getRecords(), Org.class, OrgVo.class, HashSet.class, ArrayList.class);
      this.build(vos);
      pageVo.setRecords(vos);
    }
    pageVo.setCurrent(page.getCurrent());
    pageVo.setPages(page.getPages());
    pageVo.setTotal(page.getTotal());
    return pageVo;
  }

  @Override
  public OrgVo findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    Org org = this.orgService.findDetailsById(id);
    if (Objects.isNull(org)) {
      return null;
    }
    OrgVo vo = this.nebulaToolkitService.copyObjectByWhiteList(org, OrgVo.class, HashSet.class, ArrayList.class);
    this.build(vo);
    return vo;
  }

  @Override
  public OrgVo findByOrgCode(String orgCode) {
    if (StringUtils.isBlank(orgCode)) {
      return null;
    }
    Org org = this.orgService.findByOrgCode(orgCode);
    if (Objects.isNull(org)) {
      return null;
    }
    OrgVo vo = this.nebulaToolkitService.copyObjectByWhiteList(org, OrgVo.class, HashSet.class, ArrayList.class);
    this.build(vo);
    return vo;
  }

  @Override
  public List<OrgVo> findDetailsByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return null;
    }
    List<Org> orgs = this.orgService.findDetailsByIds(ids);
    if (CollectionUtils.isEmpty(orgs)) {
      return null;
    }
    List<OrgVo> vos = (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class);
    this.build(vos);
    return vos;
  }

  @Override
  public List<OrgVo> findAllParentByOrgCode(String orgCode) {
    if (StringUtils.isNotEmpty(orgCode)) {
      List<Org> orgs = orgService.findAllParentByOrgCode(orgCode);
      if (CollectionUtils.isEmpty(orgs)) {
        return null;
      }
      List<OrgVo> vos = (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class);
      this.build(vos);
      return vos;
    }
    return null;
  }

  @Override
  public List<OrgVo> findAllParentByOrgCodes(List<String> orgCodes) {
    if (CollectionUtils.isNotEmpty(orgCodes)) {
      List<Org> orgs = orgService.findAllParentByOrgCodes(orgCodes);
      if (CollectionUtils.isEmpty(orgs)) {
        return null;
      }
      List<OrgVo> vos = (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class);
      this.build(vos);
      return vos;
    }
    return null;
  }

  @Override
  public Set<String> findByOrgQueryDto(OrgQueryDto dto) {
    if (Objects.isNull(dto) || StringUtils.isAllBlank(dto.getOrgName())) {
      return Sets.newHashSet();
    }
    return this.orgRepository.findByOrgQueryDto(dto);
  }

  @Override
  public List<OrgVo> findByOrgCodes(List<String> orgCodes) {
    if (CollectionUtils.isEmpty(orgCodes)) {
      return null;
    }
    List<Org> orgs = this.orgService.findByOrgCodes(orgCodes);
    if (CollectionUtils.isEmpty(orgs)) {
      return null;
    }
    List<OrgVo> vos = (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class);
    this.build(vos);
    return vos;
  }

  @Override
  public List<OrgVo> findAllChildrenById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    List<Org> orgs = this.orgService.findAllChildrenById(id);
    if (CollectionUtils.isEmpty(orgs)) {
      return null;
    }
    List<OrgVo> vos = (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class);
    this.build(vos);
    return vos;
  }

  @Override
  public List<OrgVo> findAllChildrenByOrgCode(String orgCode) {
    if (StringUtils.isBlank(orgCode)) {
      return null;
    }
    List<Org> orgs = this.orgService.findAllChildrenByOrgCode(orgCode);
    if (CollectionUtils.isEmpty(orgs)) {
      return null;
    }
    List<OrgVo> vos = (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class);
    this.build(vos);
    return vos;
  }

  @Override
  public List<OrgVo> findAllChildrenByOrgCodes(List<String> orgCodes) {
    if (CollectionUtils.isEmpty(orgCodes)) {
      return null;
    }
    List<Org> orgs = this.orgService.findAllChildrenByOrgCodes(orgCodes);
    if (CollectionUtils.isEmpty(orgs)) {
      return null;
    }
    return (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public List<OrgVo> findAllChildrenByOrgTypes(List<String> orgTypes) {
    if (CollectionUtils.isEmpty(orgTypes)) {
      return null;
    }
    List<Org> orgs = this.orgService.findAllChildrenByOrgTypes(orgTypes);
    if (CollectionUtils.isEmpty(orgs)) {
      return null;
    }
    return (List<OrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public Map<String, String> findByRelateOrgCodeQueryDto(RelateOrgCodeQueryDto dto) {
    if (Objects.isNull(dto) || CollectionUtils.isEmpty(dto.getOrgCodeSet())) {
      return Maps.newHashMap();
    }
    dto.setSearchType(Optional.ofNullable(dto.getSearchType()).orElse(0));
    List<Org> orgList =
        this.orgRepository.findByOrgCodes(
            Lists.newArrayList(dto.getOrgCodeSet()), TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(orgList)) {
      return Maps.newHashMap();
    }
    if (dto.getSearchType() == 0) {
      return orgList.stream()
          .filter(a -> StringUtils.isNoneBlank(a.getOrgCode(), a.getRuleCode()))
          .collect(Collectors.toMap(Org::getOrgCode, Org::getRuleCode, (a, b) -> a));
    }
    List<String> ruleCodeList =
        orgList.stream()
            .filter(a -> StringUtils.isNotBlank(a.getRuleCode()))
            .map(Org::getRuleCode)
            .distinct()
            .collect(Collectors.toList());
    if (CollectionUtils.isEmpty(ruleCodeList)) {
      return Maps.newHashMap();
    }

    TreeRuleCodeStrategy treeRuleCodeStrategy = treeRuleCodeStrategyHolder.getStrategy(null);
    if (dto.getSearchType() > 0) {
      Set<String> ruleCodeSet =
          treeRuleCodeStrategy.findParentRuleCodesByRuleCodesExcludeSelf(
              OrgCodeConstant.RULE_CODE_LENGTH, ruleCodeList);
      if (CollectionUtils.isEmpty(ruleCodeSet)) {
        ruleCodeSet = Sets.newHashSet();
      }
      ruleCodeSet.addAll(ruleCodeList);
      if (CollectionUtils.isNotEmpty(ruleCodeSet)) {
        final List<Org> cur =
            this.orgRepository.findByRuleCodesAndEnableStatus(
                Lists.newLinkedList(ruleCodeSet), null, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(cur)) {
          return Maps.newHashMap();
        }
        return cur.stream()
            .collect(Collectors.toMap(Org::getOrgCode, Org::getRuleCode, (a, b) -> a));
      }
    } else {
      final List<Org> cur =
          this.orgRepository.findChildrenByRuleCode(
              ruleCodeList, TenantUtils.getTenantCode());
      if (CollectionUtils.isEmpty(cur)) {
        return Maps.newHashMap();
      }
      return cur.stream().collect(Collectors.toMap(Org::getOrgCode, Org::getRuleCode, (a, b) -> a));
    }
    return Maps.newHashMap();
  }

  /**
   * 构建返回字段
   *
   * @param vo
   */
  private void build(OrgVo vo) {
    OrgVo parent = vo.getParent();
    if (parent != null) {
      vo.setParentName(parent.getOrgName());
    }
  }

  /**
   * 构建返回字段
   *
   * @param vos
   */
  private void build(List<OrgVo> vos) {
    vos = vos.stream().map(item -> {
      this.build(item);
      return item;
    }).collect(Collectors.toList());
  }
}
