/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.authority;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component(value="orgTreeScopeRegister")
public class OrgTreeScopeRegister
implements SelectScopeRegister {
    @Autowired(required=false)
    private ApplicationContext applicationContext;

    public String scopeKey() {
        return "org_tree_scope";
    }

    public String selectName() {
        return "\u5f53\u524d\u53ca\u4e0b\u7ea7\u7ec4\u7ec7";
    }

    public String controlKey() {
        return "org_tree";
    }

    public String controlName() {
        return "\u7ec4\u7ec7\u9009\u62e9\u6811";
    }

    public boolean matched(LoginDetails loginDetails, String[] scopeValues) {
        OrgService orgService = (OrgService)this.applicationContext.getBean(OrgService.class);
        if (scopeValues == null || scopeValues.length == 0) {
            return false;
        }
        if (!(loginDetails instanceof LoginUserDetails)) {
            return false;
        }
        LoginUserDetails loginUserDetails = (LoginUserDetails)loginDetails;
        List<String> orgCodes = Arrays.asList(scopeValues);
        if (orgCodes.contains(loginUserDetails.getOrgCode())) {
            return true;
        }
        List<Org> children = orgService.findAllChildrenByOrgCodes(orgCodes);
        if (CollectionUtils.isEmpty(children)) {
            return false;
        }
        Set scopeSet = children.stream().map(Org::getOrgCode).collect(Collectors.toSet());
        return scopeSet.contains(loginUserDetails.getOrgCode());
    }
}

