/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u4fe1\u606f: OrgVo: \u7ec4\u7ec7\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/org/org"})
public class OrgVoController {
    private static final Logger log = LoggerFactory.getLogger(OrgVoController.class);
    @Autowired(required=false)
    private OrgVoService orgVoService;

    @GetMapping(value={"/findByOrgCodes"})
    public Result<List<OrgVo>> findByOrgCodes(@RequestParam(value="orgCodeList") List<String> orgCodeList) {
        try {
            return Result.ok((Object)this.orgVoService.findByOrgCodes(orgCodeList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/findBySalesOrgCodes"})
    public Result<List<OrgVo>> findBySalesOrgCodes(@RequestBody List<String> salesOrgCodeList) {
        try {
            return Result.ok((Object)this.orgVoService.findBySalesOrgCodes(salesOrgCodeList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e \u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2 \u5168\u90e8\u4e0a\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @GetMapping(value={"/findAllParentByOrgCode"})
    public Result<List<OrgVo>> findAllParentByIdOrOrgCode(@RequestParam(value="orgCode") String orgCode) {
        try {
            List list = this.orgVoService.findAllParentByOrgCode(orgCode);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e \u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u67e5\u8be2 \u5168\u90e8\u4e0a\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @GetMapping(value={"/findAllParentByOrgCodes"})
    public Result<List<OrgVo>> findAllParentByIdOrOrgCode(@RequestParam(value="orgCodes") List<String> orgCodes) {
        try {
            List list = this.orgVoService.findAllParentByOrgCodes(orgCodes);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e \u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u67e5\u8be2 \u5168\u90e8\u4e0a\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @GetMapping(value={"/findAllChildrenByOrgCode"})
    public Result<List<OrgVo>> findAllChildrenByOrgCode(@RequestParam(value="orgCode") String orgCode) {
        try {
            List list = this.orgVoService.findAllChildrenByOrgCode(orgCode);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u7f16\u7801")
    @GetMapping(value={"/findByOrgQueryDto"})
    public Result<Set<String>> findByOrgQueryDto(OrgQueryDto dto) {
        try {
            Set set = this.orgVoService.findByOrgQueryDto(dto);
            return Result.ok((Object)set);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u83b7\u53d6\u7ec4\u7ec7\u5bf9\u5e94\u7684\u672a\u5220\u9664\u7684\u4e0a\u7ea7\u6216\u4e0b\u7ea7\u7f16\u7801")
    @GetMapping(value={"/findByRelateOrgCodeQueryDto"})
    public Result<Map<String, String>> findByRelateOrgCodeQueryDto(RelateOrgCodeQueryDto dto) {
        try {
            return Result.ok((Object)this.orgVoService.findByRelateOrgCodeQueryDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

