/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.common.enums.OrgTypeEnum;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgPageSelectReqVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgReqVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgRespVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgSearchReqVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgSelectReqVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgSelectRespVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgTreeRespVo;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgTreeVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgTreeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65e7\u7248\u7ec4\u7ec7\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/mdmOrgController"})
@Deprecated
public class MdmOrgController {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgController.class);
    @Autowired(required=false)
    private OrgService orgService;
    @Autowired(required=false)
    private OrgTreeVoService orgTreeVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @Deprecated
    public Result<Page<MdmOrgRespVo>> pageList(@RequestBody MdmOrgReqVo reqVo) {
        try {
            Org org;
            PageRequest pageable = PageRequest.of((int)reqVo.getPageNum(), (int)reqVo.getPageSize());
            OrgPaginationDto paginationDto = new OrgPaginationDto();
            paginationDto.setEnableStatus(reqVo.getEnableStatus());
            paginationDto.setOrgType(reqVo.getOrgType());
            paginationDto.setOrgCode(reqVo.getOrgCode());
            paginationDto.setOrgName(reqVo.getOrgName());
            paginationDto.setParentCode(reqVo.getParentCode());
            paginationDto.setOrgTypeList(reqVo.getOrgTypeList());
            if (StringUtils.isNotBlank((CharSequence)reqVo.getOrgCode()) && (org = this.orgService.findByOrgCode(reqVo.getCode())) != null) {
                paginationDto.setRuleCode(org.getRuleCode());
            }
            Page<Org> page = this.orgService.findByConditions((Pageable)pageable, paginationDto);
            Page<MdmOrgRespVo> pageVo = this.build(page);
            return Result.ok(pageVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u5206\u9875\u9009\u62e9\u5217\u8868")
    @PostMapping(value={"/pageSelectList"})
    public Result<Page<MdmOrgRespVo>> pageSelectList(@RequestBody MdmOrgPageSelectReqVo reqVo) {
        try {
            PageRequest pageable = PageRequest.of((int)reqVo.getPageNum(), (int)reqVo.getPageSize());
            OrgPaginationDto dao = new OrgPaginationDto();
            dao.setEnableStatus(reqVo.getEnableStatus());
            dao.setOrgType(reqVo.getOrgType());
            dao.setOrgCode(reqVo.getOrgCode());
            dao.setOrgName(reqVo.getOrgName());
            dao.setParentCode(reqVo.getParentCode());
            dao.setSapCostOrgCode(reqVo.getSapCostOrgCode());
            dao.setSapProfitOrgCode(reqVo.getSapProfitOrgCode());
            dao.setSapOrgCode(reqVo.getSapOrgCode());
            dao.setIncludeAllChildrenOrgCode(reqVo.getAllUnderThisOrgCodeIncludeSelf());
            dao.setIncludeAllChildrenOrgCodeExcludeSelf(reqVo.getAllUnderThisOrgCodeExcludeSelf());
            dao.setAllChildrenOrgCodesExcludeAnySelf(reqVo.getAllUnderOrgCodeListExcludeAnySelf());
            dao.setAllChildrenOrgCodesExcludeSelf(reqVo.getAllUnderOrgCodeListExcludeSelf());
            dao.setAllChildrenOrgCodesIncludeSelf(reqVo.getAllUnderOrgCodeListIncludeSelf());
            Page<Org> page = this.orgService.findByConditions((Pageable)pageable, dao);
            Page<MdmOrgRespVo> pageVo = this.build(page);
            return Result.ok(pageVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public Result<MdmOrgRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="orgCode", required=false) String orgCode) {
        try {
            Org org = null;
            if (StringUtils.isNotBlank((CharSequence)id)) {
                org = this.orgService.findDetailsById(id);
            }
            if (StringUtils.isNotBlank((CharSequence)orgCode)) {
                org = this.orgService.findByOrgCode(orgCode);
            }
            MdmOrgRespVo vo = this.build(org);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u7ec4\u7ec7\u4e3b\u8868\u4fe1\u606f")
    @PostMapping(value={"/detailBatchByIds"})
    @Deprecated
    public Result<List<MdmOrgRespVo>> detailBatchByIds(@RequestBody List<String> ids) {
        try {
            List<Org> orgs = this.orgService.findDetailsByIds(ids);
            List<MdmOrgRespVo> vos = this.build(orgs);
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u7ec4\u7ec7\u4e3b\u8868\u4fe1\u606f")
    @PostMapping(value={"/detailBatchByOrgCodeList"})
    @Deprecated
    public Result<List<MdmOrgRespVo>> detailBatchByOrgCodeList(@RequestBody List<String> orgCodeList) {
        try {
            List<Org> orgs = this.orgService.findByOrgCodes(orgCodeList);
            List<MdmOrgRespVo> vos = this.build(orgs);
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result<?> delete(@RequestBody List<String> ids) {
        try {
            this.orgService.deleteByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    @Deprecated
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.orgService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    @Deprecated
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.orgService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<?> save(@RequestBody Org org) {
        try {
            this.orgService.create(org);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<?> update(@RequestBody Org org) {
        try {
            this.orgService.update(org);
            return Result.ok((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5168\u90e8\u4e0b\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/findAllChildrenOrgList"})
    public Result<List<MdmOrgRespVo>> findAllChildrenOrgList(@RequestBody OrgPaginationDto dto) {
        try {
            List<Org> list = null;
            list = StringUtils.isNotBlank((CharSequence)dto.getId()) ? this.orgService.findAllChildrenById(dto.getId()) : this.orgService.findAllChildrenByOrgCode(dto.getOrgCode());
            List<MdmOrgRespVo> vos = this.build(list);
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u4e0b\u7ea7\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/findChildrenOrgList"})
    public Result<List<MdmOrgRespVo>> findChildrenOrgList(@RequestBody OrgPaginationDto dto) {
        try {
            List<Org> list = null;
            list = StringUtils.isNotBlank((CharSequence)dto.getId()) ? this.orgService.findChildrenById(dto.getId()) : this.orgService.findChildrenByOrgCode(dto.getOrgCode());
            List<MdmOrgRespVo> vos = this.build(list);
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5168\u90e8\u4e0a\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/findAllParentOrgList"})
    public Result<List<MdmOrgRespVo>> findAllParentOrgList(@RequestBody OrgPaginationDto dto) {
        try {
            List<Org> list = null;
            list = StringUtils.isNotBlank((CharSequence)dto.getId()) ? this.orgService.findAllParentById(dto.getId()) : this.orgService.findAllParentByOrgCode(dto.getOrgCode());
            List<MdmOrgRespVo> vos = this.build(list);
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u7684\u76f4\u63a5\u4e0a\u7ea7\u7ec4\u7ec7")
    @PostMapping(value={"/findSingleParentOrg"})
    public Result<MdmOrgRespVo> findSingleParentOrg(@RequestBody OrgPaginationDto dto) {
        try {
            Org parent = null;
            parent = StringUtils.isNotBlank((CharSequence)dto.getId()) ? this.orgService.findParentById(dto.getId()) : this.orgService.findParentByOrgCode(dto.getOrgCode());
            MdmOrgRespVo parentVo = this.build(parent);
            return Result.ok((Object)parentVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u7684\u76f4\u63a5\u4e0a\u7ea7\u7ec4\u7ec7", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/getParentOrg"})
    public Result<MdmOrgRespVo> getParentOrg(@RequestParam(value="id", required=false) String id, @RequestParam(value="orgCode", required=false) String orgCode) {
        try {
            Org parent = null;
            parent = StringUtils.isNotBlank((CharSequence)id) ? this.orgService.findParentById(id) : this.orgService.findParentByOrgCode(orgCode);
            MdmOrgRespVo parentVo = this.build(parent);
            return Result.ok((Object)parentVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u7ec4\u7ec7\u6811\u964d\u7ef4\u7f16\u7801")
    @PostMapping(value={"/resetRuleCode"})
    public Result<?> resetRuleCode() {
        try {
            this.orgService.updateRuleCode();
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6e05\u9664\u5168\u90e8\u7f13\u5b58")
    @PostMapping(value={"/deleteAllCache"})
    public Result<?> deleteAllCache() {
        try {
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u91cd\u65b0\u52a0\u8f7d\u5168\u90e8\u7f13\u5b58")
    @PostMapping(value={"/reloadAllCache"})
    public Result<?> reloadAllCache() {
        try {
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u67e5\u8be2\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7,\u8fd4\u56de\uff08pageSize\uff09\u5bf9\u5e94\u6761\u6570")
    @PostMapping(value={"/findOrgAndChildrenList"})
    public Result<List<MdmOrgRespVo>> findOrgAndChildrenList(@RequestBody MdmOrgSearchReqVo reqVo) {
        try {
            PageRequest pageable = PageRequest.of((int)reqVo.getPageNum(), (int)reqVo.getPageSize());
            List<Org> list = this.orgService.findAllChildrenByOrgCodes((Pageable)pageable, reqVo.getUnderOrgCodeList());
            List<MdmOrgRespVo> vos = this.build(list);
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/listCondition"})
    public Result<List<MdmOrgRespVo>> listCondition(@RequestBody MdmOrgReqVo reqVo) {
        try {
            List<Org> list = this.orgService.findByOrgCodes(reqVo.getOrgCodeList().stream().collect(Collectors.toList()));
            List<MdmOrgRespVo> vos = this.build(list);
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7\uff08\u4e0d\u5206\u9875\uff0c\u6570\u636e\u91cf\u5927\uff0c\u7ed9\u540e\u53f0\u7528\uff09(\u542f\u7528\u72b6\u6001\u3001\u7ec4\u7ec7\u7c7b\u578b\u3001\u4e0a\u7ea7\u7f16\u7801\u7cbe\u786e\u67e5\u8be2\uff0c\u7ec4\u7ec7\u7f16\u7801\u3001\u540d\u79f0\u6a21\u7cca\u67e5\u8be2)")
    @PostMapping(value={"/findOrgList"})
    public Result<List<MdmOrgRespVo>> findOrgList(@RequestBody MdmOrgReqVo reqVo) {
        try {
            OrgPaginationDto dao = new OrgPaginationDto();
            dao.setEnableStatus(reqVo.getEnableStatus());
            dao.setOrgType(reqVo.getOrgType());
            dao.setOrgCode(reqVo.getOrgCode());
            dao.setOrgName(reqVo.getOrgName());
            dao.setParentCode(reqVo.getParentCode());
            List<Org> list = this.orgService.findByConditions(dao);
            List<MdmOrgRespVo> vos = this.build(list);
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8\u7ec4\u7ec7")
    @GetMapping(value={"/getAll"})
    public Result<List<MdmOrgRespVo>> getAll() {
        try {
            OrgPaginationDto dao = new OrgPaginationDto();
            List<Org> list = this.orgService.findByConditions(dao);
            List<MdmOrgRespVo> vos = this.build(list);
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7\u6811\u5f62\u7ed3\u6784\uff08\u7ed9\u540e\u53f0\u4f7f\u7528\uff09\uff0c\u65e0\u7b5b\u9009\u6761\u4ef6\uff0c\u5168\u90e8\u8fd4\u56de\uff08\u5305\u542b\u505c\u7528\uff09")
    @GetMapping(value={"/getOrgTree"})
    public Result<List<MdmOrgTreeRespVo>> getOrgTree() {
        try {
            List trees = this.orgTreeVoService.findAllStruTree();
            List treeVos = null;
            if (CollectionUtils.isNotEmpty((Collection)trees)) {
                treeVos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)trees, OrgTreeVo.class, MdmOrgTreeRespVo.class, HashSet.class, ArrayList.class, new String[0]);
            }
            return Result.ok(treeVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u641c\u7d22\u6811")
    @PostMapping(value={"/orgSearchTree"})
    public Result<List<MdmOrgTreeRespVo>> orgSearchTree(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        try {
            List trees = this.orgTreeVoService.findByOrgNameStruTree(mdmOrgReqVo.getOrgName(), "");
            List treeVos = null;
            if (CollectionUtils.isNotEmpty((Collection)trees)) {
                treeVos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)trees, OrgTreeVo.class, MdmOrgTreeRespVo.class, HashSet.class, ArrayList.class, new String[0]);
            }
            return Result.ok(treeVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u8fd9\u4e9b\u7ec4\u7ec7\uff08\u4e0d\u542b\u81ea\u5df1\uff09\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u7f16\u7801\uff0c\u5982\u679c\u53c2\u6570\u672c\u8eab\u6709\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u5219\u4f1a\u8fd4\u56de\u5904\u4e8e\u4e0a\u7ea7\u7684\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/findAllParentOrgCodeExcludeSelf"})
    public Result<List<String>> findAllParentOrgCodeExcludeSelf(@RequestBody List<String> orgCodeList) {
        try {
            List<Org> list = this.orgService.findAllParentByOrgCodesExcludeSelf(orgCodeList);
            List parentOrgCodes = null;
            if (CollectionUtils.isNotEmpty(list)) {
                parentOrgCodes = list.stream().map(Org::getOrgCode).collect(Collectors.toList());
            }
            return Result.ok(parentOrgCodes);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u4e0b\u62c9\u6846(\u53ea\u67e5\u542f\u7528\u7684)")
    @PostMapping(value={"/select"})
    public Result<List<MdmOrgSelectRespVo>> select(@RequestBody MdmOrgSelectReqVo reqVo) {
        try {
            PageRequest pageable = PageRequest.of((int)0, (int)reqVo.getPageSize());
            OrgPaginationDto dto = new OrgPaginationDto();
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            if (reqVo != null) {
                dto.setOrgType(reqVo.getOrgType());
                dto.setOrgCode(reqVo.getOrgCode());
                dto.setOrgName(reqVo.getOrgName());
                dto.setParentCode(reqVo.getParentCode());
                dto.setCodeOrName(reqVo.getOrgCodeOrName());
                dto.setExcludeAllChildrenOrgCode(reqVo.getNotUnderThisOrgCode());
                dto.setIncludeAllChildrenOrgCode(reqVo.getUnderThisOrgCode());
            }
            Page<Org> page = this.orgService.findByConditions((Pageable)pageable, dto);
            List vos = null;
            if (Objects.nonNull(page)) {
                vos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)page.getRecords(), Org.class, MdmOrgSelectRespVo.class, HashSet.class, ArrayList.class, new String[0]);
            }
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u4e0b\u62c9\u6846")
    @PostMapping(value={"/findOrgSelectList"})
    public Result<List<MdmOrgSelectRespVo>> findOrgSelectList(@RequestBody MdmOrgSelectReqVo reqVo) {
        try {
            PageRequest pageable = PageRequest.of((int)0, (int)reqVo.getPageSize());
            OrgPaginationDto dto = new OrgPaginationDto();
            if (reqVo != null) {
                dto.setOrgType(reqVo.getOrgType());
                dto.setOrgCode(reqVo.getOrgCode());
                dto.setOrgName(reqVo.getOrgName());
                dto.setParentCode(reqVo.getParentCode());
                dto.setCodeOrName(reqVo.getOrgCodeOrName());
                dto.setExcludeAllChildrenOrgCode(reqVo.getNotUnderThisOrgCode());
                dto.setIncludeAllChildrenOrgCode(reqVo.getUnderThisOrgCode());
            }
            Page<Org> page = this.orgService.findByConditions((Pageable)pageable, dto);
            List vos = null;
            if (Objects.nonNull(page)) {
                vos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)page.getRecords(), Org.class, MdmOrgSelectRespVo.class, HashSet.class, ArrayList.class, new String[0]);
            }
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    private Page<MdmOrgRespVo> build(Page<Org> page) {
        Page pageVo = new Page();
        if (Objects.isNull(page)) {
            pageVo.setCurrent(page.getCurrent());
        }
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List<MdmOrgRespVo> vos = this.build(page.getRecords());
            pageVo.setRecords(vos);
        }
        pageVo.setCurrent(page.getCurrent());
        pageVo.setPages(page.getPages());
        pageVo.setTotal(page.getTotal());
        return pageVo;
    }

    private MdmOrgRespVo build(Org org) {
        if (Objects.isNull((Object)org)) {
            return null;
        }
        MdmOrgRespVo mdmOrgRespVo = (MdmOrgRespVo)this.nebulaToolkitService.copyObjectByBlankList((Object)org, MdmOrgRespVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (Objects.nonNull((Object)org.getParent())) {
            mdmOrgRespVo.setParentName(org.getParent().getOrgName());
        }
        Map orgTypeMap = OrgTypeEnum.GETMAP;
        String orgType = mdmOrgRespVo.getOrgType();
        if (StringUtils.isNotBlank((CharSequence)orgType)) {
            mdmOrgRespVo.setOrgTypeName((String)orgTypeMap.get(orgType));
        }
        return mdmOrgRespVo;
    }

    private List<MdmOrgRespVo> build(List<Org> orgs) {
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List<MdmOrgRespVo> vos = orgs.stream().map(item -> this.build((Org)((Object)item))).collect(Collectors.toList());
        return vos;
    }
}

