/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.repository.OrgRepository;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class OrgVoServiceImpl
implements OrgVoService {
    private static final Logger log = LoggerFactory.getLogger(OrgVoServiceImpl.class);
    @Autowired(required=false)
    private OrgService orgService;
    @Autowired(required=false)
    private OrgRepository orgRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Value(value="${crm.business.rule-code-length.org:}")
    private Integer ruleCodeLength;

    public Page<OrgVo> findByConditions(Pageable pageable, OrgPaginationDto paginationDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (paginationDto == null) {
            paginationDto = new OrgPaginationDto();
        }
        Page<Org> page = this.orgService.findByConditions(pageable, paginationDto);
        Page pageVo = new Page();
        if (Objects.isNull(page)) {
            return null;
        }
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)page.getRecords(), Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.build(vos);
            pageVo.setRecords(vos);
        }
        pageVo.setCurrent(page.getCurrent());
        pageVo.setPages(page.getPages());
        pageVo.setTotal(page.getTotal());
        return pageVo;
    }

    public OrgVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Org org = this.orgService.findDetailsById(id);
        if (Objects.isNull((Object)org)) {
            return null;
        }
        OrgVo vo = (OrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vo);
        return vo;
    }

    public OrgVo findByOrgCode(String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return null;
        }
        Org org = this.orgService.findByOrgCode(orgCode);
        if (Objects.isNull((Object)org)) {
            return null;
        }
        OrgVo vo = (OrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vo);
        return vo;
    }

    public List<OrgVo> findDetailsByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<Org> orgs = this.orgService.findDetailsByIds(ids);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vos);
        return vos;
    }

    public List<OrgVo> findAllParentByOrgCode(String orgCode) {
        if (StringUtils.isNotEmpty((CharSequence)orgCode)) {
            List<Org> orgs = this.orgService.findAllParentByOrgCode(orgCode);
            if (CollectionUtils.isEmpty(orgs)) {
                return null;
            }
            List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.build(vos);
            return vos;
        }
        return null;
    }

    public List<OrgVo> findAllParentByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            List<Org> orgs = this.orgService.findAllParentByOrgCodes(orgCodes);
            if (CollectionUtils.isEmpty(orgs)) {
                return null;
            }
            List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.build(vos);
            return vos;
        }
        return null;
    }

    public Set<String> findByOrgQueryDto(OrgQueryDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getOrgName()})) {
            return Sets.newHashSet();
        }
        return this.orgRepository.findByOrgQueryDto(dto);
    }

    public List<OrgVo> findByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        List<Org> orgs = this.orgService.findByOrgCodes(orgCodes);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vos);
        return vos;
    }

    public List<OrgVo> findAllChildrenById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        List<Org> orgs = this.orgService.findAllChildrenById(id);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vos);
        return vos;
    }

    public List<OrgVo> findAllChildrenByOrgCode(String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return null;
        }
        List<Org> orgs = this.orgService.findAllChildrenByOrgCode(orgCode);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vos);
        return vos;
    }

    public List<OrgVo> findAllChildrenByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        List<Org> orgs = this.orgService.findAllChildrenByOrgCodes(orgCodes);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<OrgVo> findAllChildrenByOrgTypes(List<String> orgTypes) {
        if (CollectionUtils.isEmpty(orgTypes)) {
            return null;
        }
        List<Org> orgs = this.orgService.findAllChildrenByOrgTypes(orgTypes);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgs, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Map<String, String> findByRelateOrgCodeQueryDto(RelateOrgCodeQueryDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getOrgCodeSet())) {
            return Maps.newHashMap();
        }
        dto.setSearchType(Optional.ofNullable(dto.getSearchType()).orElse(0));
        List<Org> orgList = this.orgService.findByOrgCodes(Lists.newArrayList((Iterable)dto.getOrgCodeSet()));
        if (CollectionUtils.isEmpty(orgList)) {
            return Maps.newHashMap();
        }
        if (dto.getSearchType() == 0) {
            return orgList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getOrgCode(), a.getRuleCode()})).collect(Collectors.toMap(Org::getOrgCode, TenantFlagTreeOpEntity::getRuleCode, (a, b) -> a));
        }
        List<String> ruleCodeList = orgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRuleCode())).map(TenantFlagTreeOpEntity::getRuleCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ruleCodeList)) {
            return Maps.newHashMap();
        }
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        if (dto.getSearchType() > 0) {
            Set ruleCodeSet = treeRuleCodeStrategy.findParentRuleCodesByRuleCodesExcludeSelf(this.ruleCodeLength.intValue(), ruleCodeList);
            if (CollectionUtils.isEmpty((Collection)ruleCodeSet)) {
                ruleCodeSet = Sets.newHashSet();
            }
            ruleCodeSet.addAll(ruleCodeList);
            if (CollectionUtils.isNotEmpty((Collection)ruleCodeSet)) {
                List<Org> cur = this.orgService.findByRuleCodesAndEnableStatus(Lists.newLinkedList((Iterable)ruleCodeSet), null);
                if (CollectionUtils.isEmpty(cur)) {
                    return Maps.newHashMap();
                }
                return cur.stream().collect(Collectors.toMap(Org::getOrgCode, TenantFlagTreeOpEntity::getRuleCode, (a, b) -> a));
            }
        } else {
            List<Org> cur = this.orgService.findChildrenByRuleCode(ruleCodeList);
            if (CollectionUtils.isEmpty(cur)) {
                return Maps.newHashMap();
            }
            return cur.stream().collect(Collectors.toMap(Org::getOrgCode, TenantFlagTreeOpEntity::getRuleCode, (a, b) -> a));
        }
        return Maps.newHashMap();
    }

    public List<OrgVo> findBySalesOrgCodes(List<String> salesOrgCodeList) {
        if (CollectionUtils.isEmpty(salesOrgCodeList)) {
            return Lists.newArrayList();
        }
        List<Org> orgList = this.orgRepository.findBySalesOrgCodes(salesOrgCodeList);
        if (CollectionUtils.isEmpty(orgList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(orgList, Org.class, OrgVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public OrgVo findOrgByOrgCode(String orgCode) {
        Org org = this.orgRepository.findOrgByOrgCode(orgCode);
        if (Objects.isNull((Object)org)) {
            return null;
        }
        OrgVo vo = (OrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        return vo;
    }

    public List<OrgVo> findGreatGrandFatherByOrgCode(String orgCode) {
        ArrayList list = Lists.newArrayList();
        if (ObjectUtils.isEmpty((Object)orgCode)) {
            return list;
        }
        log.info("\u6307\u5b9a\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u7956\u7ea7\u7684\u4e0b\u7ea7ChannelOrgVo\u6570parentCode\uff0c{}", (Object)orgCode);
        String ruleCode = null;
        Org org = null;
        if (StringUtils.isNotEmpty((CharSequence)orgCode)) {
            org = this.orgRepository.findOrgByOrgCode(orgCode);
        }
        Org org2 = null;
        if (!ObjectUtils.isEmpty(org)) {
            ruleCode = org.getRuleCode();
            String parentCode2 = org.getParentCode();
            log.info("\u6307\u5b9a\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u7956\u7ea7\u7684\u4e0b\u7ea7ChannelOrgVo\u6570parentCode2\uff0c{}", (Object)parentCode2);
            if (StringUtils.isNotEmpty((CharSequence)parentCode2)) {
                org2 = this.orgRepository.findOrgByOrgCode(parentCode2);
            }
        }
        Org org3 = null;
        if (!ObjectUtils.isEmpty(org2)) {
            ruleCode = org2.getRuleCode();
            String parentCode3 = org2.getParentCode();
            log.info("\u6307\u5b9a\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u7956\u7ea7\u7684\u4e0b\u7ea7ChannelOrgVo\u6570parentCode3\uff0c{}", (Object)parentCode3);
            if (StringUtils.isNotEmpty((CharSequence)parentCode3)) {
                org3 = this.orgRepository.findOrgByOrgCode(parentCode3);
            }
        }
        Org org4 = null;
        if (!ObjectUtils.isEmpty(org3)) {
            ruleCode = org3.getRuleCode();
            String parentCode4 = org3.getParentCode();
            log.info("\u6307\u5b9a\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u7956\u7ea7\u7684\u4e0b\u7ea7ChannelOrgVo\u6570parentCode4\uff0c{}", (Object)parentCode4);
            if (StringUtils.isNotEmpty((CharSequence)parentCode4)) {
                org4 = this.orgRepository.findOrgByOrgCode(parentCode4);
            }
        }
        ruleCode = ObjectUtils.isEmpty(org4) ? ruleCode : org4.getRuleCode();
        log.info("\u6307\u5b9a\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u7956\u7ea7\u7684\u6240\u6709\u4e0b\u7ea7ChannelOrgVo\u6570RuleCode\uff0c{}", (Object)ruleCode);
        if (StringUtils.isEmpty((CharSequence)ruleCode)) {
            return list;
        }
        List<Org> parentOrgList = this.orgRepository.findChildrenOrgByRuleCode(ruleCode);
        List orgVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(parentOrgList, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        log.info("\u6307\u5b9a\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u7956\u7ea7\u7684\u4e0b\u7ea7ChannelOrgVo\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)orgVos));
        return orgVos;
    }

    public List<OrgVo> findParentAndChildrenByOrgCode(String orgCode) {
        ArrayList list = Lists.newArrayList();
        if (ObjectUtils.isEmpty((Object)orgCode)) {
            return list;
        }
        log.info("\u6307\u5b9a\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u7236\u7ea7\u7684\u4e0b\u7ea7ChannelOrgVo\u6570parentCode\uff0c{}", (Object)orgCode);
        String ruleCode = null;
        Org org = null;
        if (StringUtils.isNotEmpty((CharSequence)orgCode)) {
            org = this.orgRepository.findOrgByOrgCode(orgCode);
        }
        Org org2 = null;
        if (ObjectUtils.isNotEmpty(org)) {
            ruleCode = org.getRuleCode();
            String orgParentCode = org.getParentCode();
            log.info("\u6307\u5b9a\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u7236\u7ea7\u7684\u4e0b\u7ea7ChannelOrgVo\u6570parentCode2\uff0c{}", (Object)orgParentCode);
            if (StringUtils.isNotEmpty((CharSequence)orgParentCode)) {
                org2 = this.orgRepository.findOrgByOrgCode(orgParentCode);
            }
        }
        log.info("\u6307\u5b9a\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u7236\u7ea7\u7684\u6240\u6709\u4e0b\u7ea7ChannelOrgVo\u6570RuleCode\uff0c{}", (Object)ruleCode);
        if (StringUtils.isEmpty((CharSequence)ruleCode)) {
            return list;
        }
        List<Org> parentOrgList = this.orgRepository.findChildrenOrgByRuleCode(ruleCode);
        List orgVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(parentOrgList, Org.class, OrgVo.class, HashSet.class, ArrayList.class, new String[0]);
        log.info("\u6307\u5b9a\u4f01\u4e1a\u7ec4\u7ec7\u67e5\u8be2\u7956\u7ea7\u7684\u4e0b\u7ea7ChannelOrgVo\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)orgVos));
        return orgVos;
    }

    private void build(OrgVo vo) {
        OrgVo parent = vo.getParent();
        if (parent != null) {
            vo.setParentName(parent.getOrgName());
        }
    }

    private void build(List<OrgVo> vos) {
        vos = vos.stream().map(item -> {
            this.build((OrgVo)item);
            return item;
        }).collect(Collectors.toList());
    }
}

