package com.biz.crm.mdm.business.org.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgLazyTreeVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author hefan
 */
@Api(tags = "企业组织：OrgLazyTreeVo：企业组织懒加载树")
@Slf4j
@RestController
@RequestMapping(value = {"/v1/org/lazyTree"})
public class OrgLazyTreeVoController {

  @Autowired(required = false)
  private OrgLazyTreeVoService orgLazyTreeVoService;

  /**
   * 组织懒加载树分页
   *
   * @param treeDto
   * @return
   */
  @ApiOperation(value = "组织懒加载树分页", notes = "什么都不传返回第一层，传parentCode返回这个编码的下一级，传name模糊查询并且查询出所有上级再构建成树形，优先级parentCode > name")
  @GetMapping("/findByConditions")
  public Result<Page<LazyTreeVo>> findByConditions(@PageableDefault(50) Pageable pageable, @ApiParam(name = "treeDto", value = "查询Dto") TreeDto treeDto) {
    try {
      Page<LazyTreeVo> byTreeDto = this.orgLazyTreeVoService.findByConditions(pageable, treeDto);
      return Result.ok(byTreeDto);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 组织懒加载树 不分页
   *
   * @param treeDto
   * @return
   */
  @ApiOperation(value = "组织懒加载树", notes = "什么都不传返回第一层，传parentCode返回这个编码的下一级，传name模糊查询并且查询出所有上级再构建成树形，优先级parentCode > name")
  @GetMapping("/findByTreeDto")
  public Result<List<LazyTreeVo>> findByTreeDto(@ApiParam(name = "treeDto", value = "查询Dto") TreeDto treeDto) {
    try {
      List<LazyTreeVo> byTreeDto = this.orgLazyTreeVoService.findByTreeDto(treeDto);
      return Result.ok(byTreeDto);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
