package com.biz.crm.mdm.business.org.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 组织接口
 *
 * @author hecheng
 * @date 2021/09/27
 */
public interface OrgService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<Org> findByConditions(Pageable pageable, OrgPaginationDto paginationDto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  Org findDetailsById(String id);

  /**
   * 按组织code查询详情
   *
   * @param orgCode
   * @return
   */
  Org findByOrgCode(String orgCode);

  /**
   * 按id集合查询详情
   *
   * @param ids
   * @return
   */
  List<Org> findDetailsByIds(List<String> ids);

  /**
   * 根据组织编码或组织名称查询
   *
   * @param
   * @return
   */
  List<Org> findByOrgCodeLikeOrOrgNameLike(String orgCodeLikeorNameLike);

  /**
   * 按orgCode集合查询详情
   *
   * @param orgCodes
   * @return
   */
  List<Org> findByOrgCodes(List<String> orgCodes);

  /**
   * 按id集合删除
   *
   * @param ids
   */
  void deleteByIds(List<String> ids);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 创建组织
   *
   * @param org
   * @return
   */
  Org create(Org org);

  /**
   * 更新组织
   *
   * @param org
   * @return
   */
  Org update(Org org);

  /**
   * 查询id下的所有子节点
   *
   * @param id
   * @return
   */
  List<Org> findAllChildrenById(String id);

  /**
   * 查询orgCode下的所有子节点
   *
   * @param orgCode
   * @return
   */
  List<Org> findAllChildrenByOrgCode(String orgCode);

  /**
   * 查询orgCodes下的所有子节点
   *
   * @param orgCodes
   * @return
   */
  List<Org> findAllChildrenByOrgCodes(List<String> orgCodes);

  /**
   * 按id查询当前节点下的子节点，不包含子节点下面的节点
   *
   * @param id
   * @return
   */
  List<Org> findChildrenById(String id);

  /**
   * 按orgCode查询当前节点下的子节点，不包含子节点下面的节点
   *
   * @param orgCode
   * @return
   */
  List<Org> findChildrenByOrgCode(String orgCode);

  /**
   * 通过id查询所有上级
   *
   * @param id
   * @return
   */
  List<Org> findAllParentById(String id);

  /**
   * 通过orgCode查询所有上级
   *
   * @param orgCode
   * @return
   */
  List<Org> findAllParentByOrgCode(String orgCode);

  /**
   * 通过orgCodes查询所有上级
   *
   * @param orgCodes
   * @return
   */
  List<Org> findAllParentByOrgCodes(List<String> orgCodes);

  /**
   * 通过ruleCodes集合查询所有上级
   *
   * @param ruleCodes
   * @return
   */
  List<Org> findAllParentByRuleCodes(List<String> ruleCodes);

  /**
   * 根据组织编码集合查询这些组织（不含自己）的上级组织编码，如果参数本身有上下级关系，则会返回处于上级的组织编码
   *
   * @param orgCodes
   * @return
   */
  List<Org> findAllParentByOrgCodesExcludeSelf(List<String> orgCodes);

  /**
   * 通过id 查询当前组织的直接上级组织
   *
   * @param id
   * @return
   */
  Org findParentById(String id);

  /**
   * 通过orgCode 查询当前组织的直接上级组织
   *
   * @param orgCode
   * @return
   */
  Org findParentByOrgCode(String orgCode);


  /**
   * 分页按orgCodes查询当前节点下的子节点，包含子节点下面的节点
   *
   * @param pageable
   * @param orgCodes
   * @return
   */
  List<Org> findAllChildrenByOrgCodes(Pageable pageable, List<String> orgCodes);

  /**
   * 按条件查询 启用状态、组织类型、上级编码精确查询，组织编码、名称模糊查询
   *
   * @param dto
   * @return
   */
  List<Org> findByConditions(OrgPaginationDto dto);

  /**
   * 按父节点code 查询
   *
   * @param orgCode
   * @return
   */
  List<Org> findByParentCode(String orgCode);

  /**
   * 重置降维编码
   */
  void updateRuleCode();

  /**
   * 查询orgTypes下的所有子节点
   *
   * @param orgTypes
   * @return
   */
  List<Org> findAllChildrenByOrgTypes(List<String> orgTypes);

  /**
   * 按ruleCodes查询所有子节点
   *
   * @param ruleCodes
   * @return
   */
  List<Org> findChildrenByRuleCode(List<String> ruleCodes);

  /**
   * 按降维码集合，和状态查询
   *
   * @param ruleCodes
   * @param enable
   * @return
   */
  List<Org> findByRuleCodesAndEnableStatus(List<String> ruleCodes, EnableStatusEnum enable);
}
