/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.entity.OrgRegion;
import com.biz.crm.mdm.business.org.local.repository.OrgRegionRepository;
import com.biz.crm.mdm.business.org.local.service.OrgRegionService;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgRegionDto;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgRegionServiceImpl
implements OrgRegionService {
    @Autowired(required=false)
    private OrgRegionRepository orgRegionRepository;
    @Autowired(required=false)
    private OrgService orgService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RegionVoService regionVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    private static volatile Cache<String, List<OrgRegion>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OrgRegionServiceImpl() {
        if (cache != null) return;
        Class<OrgRegionServiceImpl> clazz = OrgRegionServiceImpl.class;
        synchronized (OrgRegionServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public List<OrgRegion> findByOrgCode(String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), orgCode});
        List<OrgRegion> graph = (List<OrgRegion>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgRegionRepository.findByOrgCode(orgCode, TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    @Transactional
    public List<OrgRegion> createBatch(List<OrgRegion> orgRegions) {
        if (CollectionUtils.isEmpty(orgRegions)) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        Map<String, List<OrgRegion>> relMap = orgRegions.stream().collect(Collectors.groupingBy(OrgRegion::getOrgCode));
        for (Map.Entry<String, List<OrgRegion>> item : relMap.entrySet()) {
            String orgCode = item.getKey();
            List<OrgRegion> tempOrgRegions = item.getValue();
            if (StringUtils.isBlank((CharSequence)orgCode) || CollectionUtils.isEmpty(tempOrgRegions)) continue;
            Org org = this.orgService.findByOrgCode(orgCode);
            Validate.notNull((Object)((Object)org), (String)"[%s]\u7ec4\u7ec7\u4e0d\u5b58\u5728", (Object[])new Object[]{orgCode});
            this.orgRegionRepository.deleteByOrgCode(orgCode, TenantUtils.getTenantCode());
            if (!CollectionUtils.isNotEmpty(tempOrgRegions = tempOrgRegions.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCountryCode())).map(orgRegion -> {
                Date now = new Date();
                String account = this.loginUserService.getLoginAccountName();
                orgRegion.setCreateAccount(account);
                orgRegion.setModifyAccount(account);
                orgRegion.setCreateTime(now);
                orgRegion.setModifyTime(now);
                orgRegion.setTenantCode(TenantUtils.getTenantCode());
                return orgRegion;
            }).collect(Collectors.toList()))) continue;
            this.createValidation(tempOrgRegions);
            this.orgRegionRepository.saveBatch(tempOrgRegions);
            result.addAll(tempOrgRegions);
        }
        return result;
    }

    @Override
    public List<OrgRegion> findByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), orgCodes});
        List<OrgRegion> graph = (List<OrgRegion>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgRegionRepository.findByOrgCodes(orgCodes, TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    private void createValidation(List<OrgRegion> orgRegions) {
        Stream<String> countryCodeStream = orgRegions.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCountryCode())).map(OrgRegion::getCountryCode);
        Stream<String> provinceCodeStream = orgRegions.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getProvinceCode())).map(OrgRegion::getProvinceCode);
        Stream<String> cityCodeStream = orgRegions.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCityCode())).map(OrgRegion::getCityCode);
        Stream<String> districtCodeStream = orgRegions.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getDistrictCode())).map(OrgRegion::getDistrictCode);
        Stream<String> townshipCodeStream = orgRegions.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getTownshipCode())).map(OrgRegion::getTownshipCode);
        Set regionCodes = Stream.of(countryCodeStream, provinceCodeStream, cityCodeStream, districtCodeStream, townshipCodeStream).flatMap(itemStream -> itemStream).collect(Collectors.toSet());
        Map keyValue = this.regionVoService.findRegionCodeNameMap((List)Lists.newArrayList(regionCodes));
        Validate.notNull((Object)keyValue, (String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u533a\u57df", (Object[])new Object[0]);
        ArrayList uniqueKeys = Lists.newArrayList();
        for (OrgRegion orgRegion : orgRegions) {
            Map<String, OrgRegion> uniqueKeyMap;
            List listExcludeSelf;
            Validate.isTrue((boolean)keyValue.containsKey(orgRegion.getCountryCode()), (String)"\u56fd\u5bb6\u7f16\u7801\u6709\u8bef", (Object[])new Object[0]);
            Validate.isTrue((boolean)keyValue.containsKey(orgRegion.getProvinceCode()), (String)"\u7701\u4efd\u7f16\u7801\u6709\u8bef", (Object[])new Object[0]);
            Validate.isTrue((boolean)keyValue.containsKey(orgRegion.getCityCode()), (String)"\u5e02\u7f16\u7801\u6709\u8bef", (Object[])new Object[0]);
            Validate.isTrue((boolean)keyValue.containsKey(orgRegion.getDistrictCode()), (String)"\u533a\u53bf\u7f16\u7801\u6709\u8bef", (Object[])new Object[0]);
            Validate.isTrue((boolean)keyValue.containsKey(orgRegion.getTownshipCode()), (String)"\u4e61\u9547\u7f16\u7801\u6709\u8bef", (Object[])new Object[0]);
            String key = this.generateUniqueKey(orgRegion.getCountryCode(), orgRegion.getProvinceCode(), orgRegion.getCityCode(), orgRegion.getDistrictCode(), orgRegion.getTownshipCode());
            for (String exitsKey : uniqueKeys) {
                Validate.isTrue((!Objects.equals(exitsKey, key) ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u533a\u57df\u6570\u636e\uff1a\u3010%s\u3011", (Object[])new Object[]{key});
                Validate.isTrue((!exitsKey.startsWith(key) && !key.startsWith(exitsKey) ? 1 : 0) != 0, (String)"\u533a\u57df\u5b58\u5728\u884c\u5b58\u5728\u5305\u542b\u5173\u7cfb\u6570\u636e\uff1a\u3010%s,%s\u3011", (Object[])new Object[]{key, exitsKey});
            }
            uniqueKeys.add(key);
            OrgRegionDto dto = (OrgRegionDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)orgRegion, OrgRegionDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setOrgCode(null);
            dto.setTenantCode(TenantUtils.getTenantCode());
            List<OrgRegion> list = this.orgRegionRepository.findByConditions(dto);
            if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(listExcludeSelf = list.stream().filter(x -> !Objects.equals(orgRegion.getOrgCode(), x.getOrgCode())).collect(Collectors.toList())) || !(uniqueKeyMap = list.stream().collect(Collectors.toMap(k -> this.generateUniqueKey(k.getCountryCode(), k.getProvinceCode(), k.getCityCode(), k.getDistrictCode(), k.getTownshipCode()), v -> v))).containsKey(key)) continue;
            OrgRegion useOrg = uniqueKeyMap.get(key);
            String useOrgName = useOrg.getOrgCode();
            String name = (StringUtils.isBlank((CharSequence)orgRegion.getCountryCode()) ? "" : (String)keyValue.get(orgRegion.getCountryCode())) + (StringUtils.isBlank((CharSequence)orgRegion.getProvinceCode()) ? "" : (String)keyValue.get(orgRegion.getProvinceCode())) + (StringUtils.isBlank((CharSequence)orgRegion.getCityCode()) ? "" : (String)keyValue.get(orgRegion.getCityCode())) + (StringUtils.isBlank((CharSequence)orgRegion.getDistrictCode()) ? "" : (String)keyValue.get(orgRegion.getDistrictCode())) + (StringUtils.isBlank((CharSequence)orgRegion.getTownshipCode()) ? "" : (String)keyValue.get(orgRegion.getTownshipCode()));
            Validate.isTrue((boolean)false, (String)(name + "\u5df2\u7ecf\u88ab[" + useOrgName + "]\u5173\u8054"), (Object[])new Object[0]);
        }
    }

    private String generateUniqueKey(String countryCode, String provinceCode, String cityCode, String districtCode, String townshipCode) {
        return "_" + (StringUtils.isEmpty((CharSequence)countryCode) ? "" : countryCode + "_") + (StringUtils.isEmpty((CharSequence)provinceCode) ? "" : provinceCode + "_") + (StringUtils.isEmpty((CharSequence)cityCode) ? "" : cityCode + "_") + (StringUtils.isEmpty((CharSequence)districtCode) ? "" : districtCode + "_") + (StringUtils.isEmpty((CharSequence)townshipCode) ? "" : townshipCode + "_");
    }
}

