/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.notifier;

import com.biz.crm.mdm.business.org.local.entity.OrgPosition;
import com.biz.crm.mdm.business.org.local.service.OrgPositionService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionRelationViewVo;
import com.biz.crm.mdm.business.position.sdk.event.PositionEventListener;
import com.biz.crm.mdm.business.position.sdk.vo.PositionEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class PositionEventOrgListenerImpl
implements PositionEventListener {
    @Autowired(required=false)
    private OrgPositionService orgPositionService;

    @Transactional
    public void onCreate(PositionEventVo vo) {
        if (Objects.isNull(vo)) {
            return;
        }
        List relationData = vo.getRelationData();
        if (CollectionUtils.isEmpty((Collection)relationData)) {
            return;
        }
        for (PositionRelationEventVo relation : relationData) {
            if (!Objects.equals(relation.getRelationKey(), "org")) continue;
            List relationCodes = relation.getRelationData();
            if (CollectionUtils.isEmpty((Collection)relationCodes)) {
                return;
            }
            List<OrgPosition> orgPositions = relationCodes.stream().map(item -> {
                OrgPosition orgPosition = new OrgPosition();
                orgPosition.setOrgCode(item.getCode());
                orgPosition.setPositionCode(vo.getPositionCode());
                return orgPosition;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(orgPositions)) {
                return;
            }
            this.orgPositionService.create(orgPositions);
        }
    }

    @Transactional
    public void onUpdate(PositionEventVo oldVo, PositionEventVo newVo) {
        if (Objects.isNull(oldVo) || Objects.isNull(newVo)) {
            return;
        }
        this.orgPositionService.deleteByPositionCodes(Lists.newArrayList((Object[])new String[]{oldVo.getPositionCode()}));
        List<OrgPosition> newOrgPositions = this.getOrgPositions(newVo);
        if (CollectionUtils.isEmpty(newOrgPositions)) {
            return;
        }
        this.orgPositionService.create(newOrgPositions);
    }

    private List<OrgPosition> getOrgPositions(PositionEventVo newVo) {
        List relationData = newVo.getRelationData();
        if (CollectionUtils.isEmpty((Collection)relationData)) {
            return null;
        }
        ArrayList<OrgPosition> allOrgPositions = new ArrayList<OrgPosition>();
        for (PositionRelationEventVo relation : relationData) {
            if (!Objects.equals(relation.getRelationKey(), "org")) continue;
            List relationCodes = relation.getRelationData();
            if (CollectionUtils.isEmpty((Collection)relationCodes)) {
                return null;
            }
            List orgPositions = relationCodes.stream().map(item -> {
                OrgPosition orgPosition = new OrgPosition();
                orgPosition.setOrgCode(item.getCode());
                orgPosition.setPositionCode(newVo.getPositionCode());
                return orgPosition;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(orgPositions)) {
                return null;
            }
            allOrgPositions.addAll(orgPositions);
        }
        return allOrgPositions;
    }

    @Transactional
    public void onDisable(List<PositionEventVo> voList) {
    }

    @Transactional
    public void onEnable(List<PositionEventVo> voList) {
    }

    public void onDelete(List<PositionEventVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        List<String> positionCodes = voList.stream().map(PositionEventVo::getPositionCode).collect(Collectors.toList());
        this.orgPositionService.deleteByPositionCodes(positionCodes);
    }

    public List<PositionRelationVo> onRequestByPositionCodes(List<String> positionCodes) {
        if (CollectionUtils.isEmpty(positionCodes)) {
            return null;
        }
        List<OrgPosition> orgPositions = this.orgPositionService.findByPositionCodes(positionCodes);
        if (CollectionUtils.isEmpty(orgPositions)) {
            return null;
        }
        Map<String, List<OrgPosition>> relMap = orgPositions.stream().collect(Collectors.groupingBy(OrgPosition::getPositionCode));
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, List<OrgPosition>> item : relMap.entrySet()) {
            PositionRelationVo vo = new PositionRelationVo();
            vo.setPositionCode(item.getKey());
            List<OrgPosition> relations = item.getValue();
            if (!CollectionUtils.isEmpty(relations)) {
                List relationVos = relations.stream().map(temp -> {
                    OrgPositionRelationViewVo viewVo = new OrgPositionRelationViewVo();
                    viewVo.setCode(temp.getOrgCode());
                    return viewVo;
                }).collect(Collectors.toList());
                vo.setRelationData((List)Lists.newArrayList(relationVos));
            }
            vo.setRelationKey("org");
            vo.setRelationName("\u7ec4\u7ec7");
            list.add(vo);
        }
        return list;
    }
}

