package com.biz.crm.mdm.business.org.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 组织职位关系实体类
 *
 * @author hecheng
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_org_position")
@ApiModel("组织职位关系实体类")
@Table(name = "mdm_org_position")
@Entity
public class OrgPosition extends TenantEntity {
  private static final long serialVersionUID = 3026459516324389289L;

  /**
   * 组织编码
   */
  @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '组织编码'")
  @TableField(value = "org_code")
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 职位编码
   */
  @Column(name = "position_code", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '职位编码'")
  @TableField(value = "position_code")
  @ApiModelProperty("职位编码")
  private String positionCode;

}
