package com.biz.crm.mdm.business.org.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 组织实体 mybatis-plus接口类
 *
 * @author hecheng
 * @date 2021/09/26
 */
public interface OrgMapper extends BaseMapper<Org> {

  /**
   * 根据 Org 主键查询详细信息（包括关联表）
   *
   * @param id
   * @return
   */
  Org findDetailsById(@Param("id") String id, @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 根据 orgCode 编码 查询
   *
   * @param orgCode
   * @param tenantCode
   * @return
   */
  Org findByOrgCode(@Param("orgCode") String orgCode, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 分页查询
   *
   * @param page
   * @param paginationDto
   * @return
   */
  //@SqlPrivilege
  Page<Org> findByConditions(Page<Org> page, @Param("dto") OrgPaginationDto paginationDto, @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 根据 Org 主键集合查询详细信息（包括关联表）
   *
   * @param ids
   * @return
   */
  List<Org> findDetailsByIds(@Param("ids") List<String> ids, @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 根据 orgCode集合查询详细信息（包括关联表）
   *
   * @param orgCodes
   * @param tenantCode
   * @return
   */
  List<Org> findByOrgCodes(@Param("orgCodes") List<String> orgCodes, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 按父节点code集合查询
   *
   * @param parentCodes
   * @param tenantCode
   * @return
   */
  List<Org> findByParentCodes(@Param("parentCodes") List<String> parentCodes, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 按ruleCode 集合查询所有子集合的组织code
   *
   * @param ruleCodes
   * @param tenantCode
   * @return
   */
  List<String> findChildrenOrgCodeByRuleCodes(@Param("ruleCodes") List<String> ruleCodes, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 按ruleCode 集合查询所有子集合的组织
   *
   * @param ruleCodes
   * @param tenantCode
   * @return
   */
  List<Org> findChildrenByRuleCodes(@Param("ruleCodes") List<String> ruleCodes, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 分页通过ruleCodes 查询子节点信息
   *
   * @param page
   * @param ruleCodes
   * @param tenantCode
   * @return
   */
  Page<Org> findChildrenByRuleCodes(Page<Org> page, @Param("ruleCodes") List<String> ruleCodes, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 查询企业组织懒加载数据
   *
   * @param enableStatus    启用状态
   * @param topOnly         传true只查第一层
   * @param parentCode      只查询该编码下一级
   * @param codeList        只查询这些编码
   * @param ruleCodeList    只查询这些降维编码
   * @param excludeRuleCode 排除这个降维编码的下级
   * @param tenantCode
   * @return
   */
  List<LazyTreeVo> findOrgLazyTreeList(@Param("enableStatus") String enableStatus,
                                       @Param("topOnly") Boolean topOnly,
                                       @Param("parentCode") String parentCode,
                                       @Param("codeList") List<String> codeList,
                                       @Param("ruleCodeList") List<String> ruleCodeList,
                                       @Param("excludeRuleCode") String excludeRuleCode,
                                       @Param("tenantCode") String tenantCode,
                                       @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 查找parentCode不为空但找不到对应上级的数据(包括已被删除的数据),设置parentCode为null
   *
   * @param tenantCode
   */
  void updateOrphanParentCodeNull(@Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);
}
