/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.local.service.OrgPositionService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPositionBindDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\uff1aOrgPositionVo\uff1a\u7ec4\u7ec7\u5173\u8054\u804c\u4f4d\u7684\u76f8\u5173\u7684\u5185\u5bb9"})
@RestController
@RequestMapping(value={"/v1/org/position"})
public class OrgPositionVoController {
    private static final Logger log = LoggerFactory.getLogger(OrgPositionVoController.class);
    @Autowired(required=false)
    private OrgPositionService orgPositionService;
    @Autowired(required=false)
    private OrgPositionVoService orgPositionVoService;

    @ApiOperation(value="\u5173\u8054\u7ec4\u7ec7\u548c\u804c\u4f4d")
    @PostMapping(value={"/bind"})
    public Result<?> bindPosition(@RequestBody @ApiParam(name="orgPositionBindDto", value="\u5173\u8054\u7ec4\u7ec7\u548c\u804c\u4f4d") OrgPositionBindDto orgPositionBindDto) {
        try {
            this.orgPositionService.bindPosition(orgPositionBindDto);
            return Result.ok((String)"\u5173\u8054\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u7ec4\u7ec7\u548c\u804c\u4f4d\u5173\u8054")
    @DeleteMapping(value={"/unbind"})
    public Result<?> unbindPosition(@RequestParam(value="ids") List<String> ids) {
        try {
            this.orgPositionService.unbindPosition(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f")
    @PostMapping(value={"/findByPositionCode"})
    public Result<OrgVo> findByPositionCode(@RequestParam(value="positionCode") String positionCode) {
        try {
            OrgVo orgVo = this.orgPositionVoService.findByPositionCode(positionCode);
            return Result.ok((Object)orgVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7\u804c\u4f4d\u96c6\u5408")
    @GetMapping(value={"/findByOrgCodes"})
    public Result<List<OrgPositionVo>> findByOrgCodes(@RequestParam(value="orgCodes") List<String> orgCodes) {
        try {
            return Result.ok((Object)this.orgPositionVoService.findByOrgCodes(orgCodes));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408")
    @GetMapping(value={"/findByPositionCodes"})
    public Result<List<OrgPositionVo>> findByPositionCodes(@RequestParam(value="positionCodes") List<String> positionCodes) {
        try {
            return Result.ok((Object)this.orgPositionVoService.findByPositionCodes(positionCodes));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

