/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.internal;

import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.entity.OrgPosition;
import com.biz.crm.mdm.business.org.local.repository.OrgPositionRepository;
import com.biz.crm.mdm.business.org.local.service.OrgPositionService;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPositionBindDto;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgPositionServiceImpl
implements OrgPositionService {
    @Autowired(required=false)
    private OrgPositionRepository orgPositionRepository;
    @Autowired(required=false)
    private OrgService orgService;
    @Autowired(required=false)
    private PositionVoService positionVoService;
    private static volatile Cache<String, List<OrgPosition>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OrgPositionServiceImpl() {
        if (cache != null) return;
        Class<OrgPositionServiceImpl> clazz = OrgPositionServiceImpl.class;
        synchronized (OrgPositionServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    @Transactional
    public List<OrgPosition> create(List<OrgPosition> orgPositions) {
        if (CollectionUtils.isEmpty(orgPositions)) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (OrgPosition orgPosition : orgPositions) {
            OrgPosition current = this.createForm(orgPosition);
            OrgPosition oldRel = this.orgPositionRepository.findByPositionCodeAndOrgCode(orgPosition.getPositionCode(), orgPosition.getOrgCode(), TenantUtils.getTenantCode());
            if (Objects.nonNull((Object)oldRel)) {
                result.add(oldRel);
                continue;
            }
            this.orgPositionRepository.save((Object)current);
            result.add(current);
        }
        return result;
    }

    @Override
    public List<OrgPosition> findByPositionCodes(List<String> positionCodes) {
        if (CollectionUtils.isEmpty(positionCodes)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), positionCodes});
        List<OrgPosition> graph = (List<OrgPosition>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgPositionRepository.findByPositionCodes(positionCodes, TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    public List<OrgPosition> findByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), orgCodes});
        List<OrgPosition> graph = (List<OrgPosition>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgPositionRepository.findByOrgCodes(orgCodes, TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    @Transactional
    public void deleteByPositionCodes(List<String> positionCodes) {
        if (CollectionUtils.isEmpty(positionCodes)) {
            return;
        }
        this.orgPositionRepository.deleteByPositionCodes(positionCodes, TenantUtils.getTenantCode());
    }

    @Override
    public void bindPosition(OrgPositionBindDto orgPositionBindDto) {
        this.validateRelation(orgPositionBindDto);
        if (StringUtils.isNotBlank((CharSequence)orgPositionBindDto.getOldOrgCode())) {
            this.orgPositionRepository.removeRelationByOrgCodeAndPositionCodes(orgPositionBindDto.getOldOrgCode(), orgPositionBindDto.getPositionCodeList(), TenantUtils.getTenantCode());
        }
        List customerOrgPositions = orgPositionBindDto.getPositionCodeList().stream().map(positionCode -> {
            OrgPosition orgPosition = new OrgPosition();
            orgPosition.setTenantCode(TenantUtils.getTenantCode());
            orgPosition.setPositionCode((String)positionCode);
            orgPosition.setOrgCode(orgPositionBindDto.getOrgCode());
            return orgPosition;
        }).collect(Collectors.toList());
        this.orgPositionRepository.saveOrUpdateBatch(customerOrgPositions);
    }

    private void validateRelation(OrgPositionBindDto orgPositionBindDto) {
        Validate.notEmpty((CharSequence)orgPositionBindDto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)orgPositionBindDto.getPositionCodeList()) ? 1 : 0) != 0, (String)"\u9700\u8981\u5173\u8054\u7684\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Override
    public void unbindPosition(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f53\u8fdb\u884c\u89e3\u7ed1\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        this.orgPositionRepository.removeByIds(ids);
    }

    private OrgPosition createForm(OrgPosition orgPosition) {
        orgPosition.setTenantCode(TenantUtils.getTenantCode());
        orgPosition.setTenantCode(TenantUtils.getTenantCode());
        this.createValidation(orgPosition);
        return orgPosition;
    }

    private void createValidation(OrgPosition orgPosition) {
        Validate.notNull((Object)((Object)orgPosition), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)orgPosition.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        orgPosition.setId(null);
        Validate.notBlank((CharSequence)orgPosition.getOrgCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7ec4\u7ec7\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orgPosition.getPositionCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u804c\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String orgCode = orgPosition.getOrgCode();
        Org org = this.orgService.findByOrgCode(orgCode);
        Validate.notNull((Object)((Object)org), (String)"[%s]\u7ec4\u7ec7\u4e0d\u5b58\u5728!", (Object[])new Object[]{orgCode});
        String positionCode = orgPosition.getPositionCode();
        Validate.notNull((Object)this.positionVoService, (String)"\u672a\u53d1\u73b0\u804c\u4f4d\u6a21\u5757\u5b9e\u73b0, \u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        List positionVos = this.positionVoService.findByIdsOrCodes(null, (List)Lists.newArrayList((Object[])new String[]{positionCode}));
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)positionVos), (String)"[%s]\u804c\u4f4d\u4e0d\u5b58\u5728!", (Object[])new Object[]{positionCode});
    }
}

