/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.internal;

import com.biz.crm.mdm.business.org.local.entity.OrgRegion;
import com.biz.crm.mdm.business.org.local.service.OrgRegionService;
import com.biz.crm.mdm.business.org.sdk.service.OrgRegionVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgRegionVo;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class OrgRegionVoServiceImpl
implements OrgRegionVoService {
    @Autowired(required=false)
    private OrgRegionService orgRegionService;
    @Autowired(required=false)
    private RegionVoService regionVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<OrgRegionVo> findByOrgCode(String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return null;
        }
        List<OrgRegion> orgRegions = this.orgRegionService.findByOrgCode(orgCode);
        if (CollectionUtils.isEmpty(orgRegions)) {
            return null;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByBlankList(orgRegions, OrgRegion.class, OrgRegionVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.build(vos);
        return vos;
    }

    private void build(List<OrgRegionVo> vos) {
        Stream<String> countryCodeStream = vos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCountryCode())).map(OrgRegionVo::getCountryCode);
        Stream<String> provinceCodeStream = vos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getProvinceCode())).map(OrgRegionVo::getProvinceCode);
        Stream<String> cityCodeStream = vos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCityCode())).map(OrgRegionVo::getCityCode);
        Stream<String> districtCodeStream = vos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getDistrictCode())).map(OrgRegionVo::getDistrictCode);
        Stream<String> townshipCodeStream = vos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getTownshipCode())).map(OrgRegionVo::getTownshipCode);
        Set regionCodes = Stream.of(countryCodeStream, provinceCodeStream, cityCodeStream, districtCodeStream, townshipCodeStream).flatMap(itemStream -> itemStream).collect(Collectors.toSet());
        Map keyValue = this.regionVoService.findRegionCodeNameMap((List)Lists.newArrayList(regionCodes));
        if (Objects.isNull(keyValue)) {
            return;
        }
        vos = vos.stream().map(item -> {
            item.setCountryName((String)keyValue.get(item.getCountryCode()));
            item.setCityName((String)keyValue.get(item.getCityCode()));
            item.setProvinceName((String)keyValue.get(item.getProvinceCode()));
            item.setDistrictName((String)keyValue.get(item.getDistrictCode()));
            item.setTownshipName((String)keyValue.get(item.getTownshipCode()));
            return item;
        }).collect(Collectors.toList());
    }
}

