/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.mapper.OrgMapper;
import com.biz.crm.mdm.business.org.local.repository.OrgRepository;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.common.enums.OrgTypeEnum;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventBatchDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgLogEventDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.event.OrgEventListener;
import com.biz.crm.mdm.business.org.sdk.event.OrgLogEventListener;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="OrgServiceImpl")
public class OrgServiceImpl
implements OrgService {
    private final int ONE = 1;
    @Autowired(required=false)
    private OrgRepository orgRepository;
    @Autowired(required=false)
    @Lazy
    private List<OrgEventListener> orgEventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    private static volatile Cache<String, List<Org>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OrgServiceImpl() {
        if (cache != null) return;
        Class<OrgServiceImpl> clazz = OrgServiceImpl.class;
        synchronized (OrgServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Page<Org> findByConditions(Pageable pageable, OrgPaginationDto paginationDto) {
        List<Org> orgs;
        List allChildrenOrgCodesExcludeAnySelf;
        List<Org> orgs2;
        List<Org> orgs3;
        List<String> targetOrgCodes;
        List<String> targetRuleCodes;
        List<Org> children;
        String includeAllChildrenOrgCodeExcludeSelf;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (paginationDto == null) {
            paginationDto = new OrgPaginationDto();
        }
        paginationDto.setTenantCode(TenantUtils.getTenantCode());
        String excludeAllChildrenRuleCode = null;
        if (StringUtils.isNotBlank((CharSequence)paginationDto.getExcludeAllChildrenOrgCode())) {
            excludeAllChildrenRuleCode = this.orgRepository.findRuleCodeByOrgCode(paginationDto.getExcludeAllChildrenOrgCode(), TenantUtils.getTenantCode());
            paginationDto.setExcludeAllChildrenRuleCode(excludeAllChildrenRuleCode);
        }
        String includeAllChildrenRuleCode = null;
        if (StringUtils.isNotBlank((CharSequence)paginationDto.getIncludeAllChildrenOrgCode())) {
            includeAllChildrenRuleCode = this.orgRepository.findRuleCodeByOrgCode(paginationDto.getIncludeAllChildrenOrgCode(), TenantUtils.getTenantCode());
            paginationDto.setIncludeAllChildrenRuleCode(includeAllChildrenRuleCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(includeAllChildrenOrgCodeExcludeSelf = paginationDto.getIncludeAllChildrenOrgCodeExcludeSelf())) && CollectionUtils.isNotEmpty(children = this.orgRepository.findByParentCode(includeAllChildrenOrgCodeExcludeSelf, TenantUtils.getTenantCode()))) {
            targetRuleCodes = children.stream().filter(item -> !Objects.equals(includeAllChildrenOrgCodeExcludeSelf, item.getOrgCode())).map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
            targetOrgCodes = this.orgRepository.findChildrenOrgCodeByRuleCodes(targetRuleCodes, TenantUtils.getTenantCode());
            paginationDto.setOrgCodes(targetOrgCodes);
        }
        if (CollectionUtils.isNotEmpty((Collection)paginationDto.getAllChildrenOrgCodesIncludeSelf()) && CollectionUtils.isNotEmpty(orgs3 = this.orgRepository.findByOrgCodes(paginationDto.getAllChildrenOrgCodesIncludeSelf(), TenantUtils.getTenantCode()))) {
            targetRuleCodes = orgs3.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
            targetOrgCodes = this.orgRepository.findChildrenOrgCodeByRuleCodes(targetRuleCodes, TenantUtils.getTenantCode());
            paginationDto.setOrgCodes(targetOrgCodes);
        }
        List allChildrenOrgCodesExcludeSelf = paginationDto.getAllChildrenOrgCodesExcludeSelf();
        if (CollectionUtils.isNotEmpty((Collection)paginationDto.getAllChildrenOrgCodesExcludeSelf()) && CollectionUtils.isNotEmpty(orgs2 = this.orgRepository.findByOrgCodes(paginationDto.getAllChildrenOrgCodesExcludeSelf(), TenantUtils.getTenantCode()))) {
            List<String> targetRuleCodes2 = orgs2.stream().filter(item -> !allChildrenOrgCodesExcludeSelf.contains(item.getOrgCode())).map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
            List<String> targetOrgCodes2 = this.orgRepository.findChildrenOrgCodeByRuleCodes(targetRuleCodes2, TenantUtils.getTenantCode());
            paginationDto.setOrgCodes(targetOrgCodes2);
        }
        if (CollectionUtils.isNotEmpty((Collection)(allChildrenOrgCodesExcludeAnySelf = paginationDto.getAllChildrenOrgCodesExcludeAnySelf())) && CollectionUtils.isNotEmpty(orgs = this.orgRepository.findByOrgCodes(paginationDto.getAllChildrenOrgCodesExcludeAnySelf(), TenantUtils.getTenantCode()))) {
            List<String> targetRuleCodes3 = orgs.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
            List<String> targetOrgCodes3 = this.orgRepository.findChildrenOrgCodeByRuleCodes(targetRuleCodes3, TenantUtils.getTenantCode());
            targetOrgCodes3 = targetOrgCodes3.stream().filter(item -> !allChildrenOrgCodesExcludeAnySelf.contains(item)).collect(Collectors.toList());
            paginationDto.setOrgCodes(targetOrgCodes3);
        }
        HashSet codeList = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)paginationDto.getSelectedCode())) {
            codeList.add(paginationDto.getSelectedCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)paginationDto.getSelectedCodes())) {
            codeList.addAll(paginationDto.getSelectedCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)codeList)) {
            paginationDto.setSelectedCodes((List)Lists.newArrayList((Iterable)codeList));
        }
        return this.orgRepository.findByConditions(pageable, paginationDto);
    }

    @Override
    public Org findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.orgRepository.findDetailsById(id);
    }

    @Override
    public Org findByOrgCode(String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return null;
        }
        return this.orgRepository.findByOrgCode(orgCode, TenantUtils.getTenantCode());
    }

    @Override
    public List<Org> findDetailsByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new List[]{ids});
        List<Org> graph = (List<Org>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgRepository.findDetailsByIds(ids);
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    public List<Org> findByOrgCodeLikeOrOrgNameLike(String orgCodeLikeorNameLike) {
        return this.orgRepository.findByOrgCodeLikeOrOrgNameLike(orgCodeLikeorNameLike);
    }

    @Override
    public List<Org> findByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), orgCodes});
        List<Org> graph = (List<Org>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgRepository.findByOrgCodes(orgCodes, TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    @Transactional
    public void deleteByIds(List<String> ids) {
        Validate.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Org> orgs = this.findDetailsByIds(ids);
        Validate.notEmpty(orgs, (String)"\u65e0\u6548\u7684\u53c2\u6570", (Object[])new Object[0]);
        List<String> orgCodes = orgs.stream().map(Org::getOrgCode).collect(Collectors.toList());
        List<Org> children = this.orgRepository.findByParentCodes(orgCodes, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(children), (String)"\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        if (Objects.nonNull(this.orgEventListeners)) {
            for (OrgEventListener listener : this.orgEventListeners) {
                listener.onDelete(orgCodes);
            }
        }
        for (Org org : orgs) {
            org.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        }
        this.orgRepository.updateBatchById(orgs);
        for (Org org : orgs) {
            this.orgRepository.setParentCodeAndRuleCodeNull(org.getId());
        }
        ArrayList orgEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(children, Org.class, OrgEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        OrgEventBatchDto orgEventBatchDto = new OrgEventBatchDto();
        orgEventBatchDto.setOrgEventDtoList((List)orgEventDtoList);
        SerializableBiConsumer & Serializable sf = OrgEventListener::onDeleteBatch;
        this.nebulaNetEventClient.publish((NebulaEventDto)orgEventBatchDto, OrgEventListener.class, (SerializableBiConsumer)sf);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> ruleCodes = this.orgRepository.findRuleCodeByIds(ids);
        if (CollectionUtils.isNotEmpty(ruleCodes)) {
            Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
            TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
            Validate.notNull((Object)treeRuleCodeStrategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565", (Object[])new Object[0]);
            Set parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodesExcludeAnySelf(3, ruleCodes);
            if (CollectionUtils.isNotEmpty((Collection)parentRuleCodes)) {
                List parentDisableList = this.findByRuleCodesAndEnableStatus(new ArrayList<String>(parentRuleCodes), EnableStatusEnum.DISABLE).stream().filter(org -> !ids.contains(org.getId())).collect(Collectors.toList());
                Validate.isTrue((boolean)CollectionUtils.isEmpty(parentDisableList), (String)"\u5b58\u5728\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u7ec4\u7ec7,\u4e0d\u80fd\u542f\u7528\u5f53\u524d\u7ec4\u7ec7", (Object[])new Object[0]);
            }
        }
        this.orgRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        List orgList = ((OrgMapper)this.orgRepository.getBaseMapper()).selectBatchIds(ids);
        ArrayList orgEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)orgList, Org.class, OrgEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        OrgEventBatchDto orgEventBatchDto = new OrgEventBatchDto();
        orgEventBatchDto.setOrgEventDtoList((List)orgEventDtoList);
        SerializableBiConsumer & Serializable sf = OrgEventListener::onEnableBatch;
        this.nebulaNetEventClient.publish((NebulaEventDto)orgEventBatchDto, OrgEventListener.class, (SerializableBiConsumer)sf);
        List<Org> orgs = this.orgRepository.findDetailsByIds(ids);
        for (Org org2 : orgs) {
            OrgLogEventDto orgLogEventDto = new OrgLogEventDto();
            OrgVo oldObj = new OrgVo();
            OrgVo newObj = new OrgVo();
            oldObj.setId(org2.getId());
            newObj.setId(org2.getId());
            oldObj.setEnableStatus(org2.getEnableStatus());
            newObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            orgLogEventDto.setNewest(newObj);
            orgLogEventDto.setOriginal(oldObj);
            SerializableBiConsumer & Serializable onUpdate = OrgLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)orgLogEventDto, OrgLogEventListener.class, (SerializableBiConsumer)onUpdate);
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> orgCodes = this.findChildrenOrgCodeByIds(ids);
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            this.orgRepository.updateEnableStatusByOrgCodes(orgCodes, EnableStatusEnum.DISABLE, TenantUtils.getTenantCode());
        }
        List orgList = ((OrgMapper)this.orgRepository.getBaseMapper()).selectBatchIds(ids);
        ArrayList orgEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)orgList, Org.class, OrgEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        OrgEventBatchDto orgEventBatchDto = new OrgEventBatchDto();
        orgEventBatchDto.setOrgEventDtoList((List)orgEventDtoList);
        SerializableBiConsumer & Serializable sf = OrgEventListener::onDisableBatch;
        this.nebulaNetEventClient.publish((NebulaEventDto)orgEventBatchDto, OrgEventListener.class, (SerializableBiConsumer)sf);
        List<Org> orgs = this.orgRepository.findDetailsByIds(ids);
        for (Org org : orgs) {
            OrgLogEventDto orgLogEventDto = new OrgLogEventDto();
            OrgVo oldObj = new OrgVo();
            OrgVo newObj = new OrgVo();
            oldObj.setId(org.getId());
            newObj.setId(org.getId());
            oldObj.setEnableStatus(org.getEnableStatus());
            newObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            orgLogEventDto.setNewest(newObj);
            orgLogEventDto.setOriginal(oldObj);
            SerializableBiConsumer & Serializable onUpdate = OrgLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)orgLogEventDto, OrgLogEventListener.class, (SerializableBiConsumer)onUpdate);
        }
    }

    @Override
    @Transactional
    public Org create(Org org) {
        Org current = this.createForm(org);
        Org OrgAll = this.orgRepository.findAllByOrgCode(org);
        if (!Objects.isNull((Object)OrgAll)) {
            throw new IllegalArgumentException("\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff08\u5df2\u903b\u8f91\u5220\u9664\uff09");
        }
        this.orgRepository.save((Object)current);
        OrgLogEventDto orgLogEventDto = new OrgLogEventDto();
        orgLogEventDto.setNewest((OrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, OrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        SerializableBiConsumer & Serializable onCreate = OrgLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)orgLogEventDto, OrgLogEventListener.class, (SerializableBiConsumer)onCreate);
        return current;
    }

    @Override
    @Transactional
    public Org update(Org org) {
        Org current = this.updateForm(org);
        return current;
    }

    @Override
    public List<Org> findAllChildrenById(String id) {
        Org parent = this.findDetailsById(id);
        if (Objects.isNull((Object)parent)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), parent.getRuleCode()});
        List<Org> graph = (List<Org>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgRepository.findChildrenByRuleCode(parent.getRuleCode(), TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    public List<Org> findAllChildrenByOrgCode(String orgCode) {
        Org parent = this.findByOrgCode(orgCode);
        if (Objects.isNull((Object)parent)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), parent.getRuleCode()});
        List<Org> graph = (List<Org>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgRepository.findChildrenByRuleCode(parent.getRuleCode(), TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    public List<Org> findAllChildrenByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        List<String> ruleCodes = this.orgRepository.findRuleCodeByOrgCodes(orgCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), ruleCodes});
        List<Org> graph = (List<Org>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgRepository.findChildrenByRuleCode(ruleCodes, TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    public List<Org> findChildrenById(String id) {
        Org parent = this.findDetailsById(id);
        if (Objects.isNull((Object)parent)) {
            return null;
        }
        return this.orgRepository.findByParentCode(parent.getOrgCode(), TenantUtils.getTenantCode());
    }

    @Override
    public List<Org> findChildrenByOrgCode(String orgCode) {
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), orgCode});
        List<Org> graph = (List<Org>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgRepository.findByParentCode(orgCode, TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    public List<Org> findAllParentById(String id) {
        Org current = this.findDetailsById(id);
        if (Objects.isNull((Object)current)) {
            return null;
        }
        return this.findAllParentByRuleCodes(Lists.newArrayList((Object[])new String[]{current.getRuleCode()}));
    }

    @Override
    public List<Org> findAllParentByOrgCode(String orgCode) {
        Org current = this.findByOrgCode(orgCode);
        if (Objects.isNull((Object)current)) {
            return null;
        }
        return this.findAllParentByRuleCodes(Lists.newArrayList((Object[])new String[]{current.getRuleCode()}));
    }

    @Override
    public List<Org> findAllParentByOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        List<Org> orgs = this.findByOrgCodes(orgCodes);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List<String> ruleCodes = orgs.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getRuleCode())).map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
        return this.findAllParentByRuleCodes(ruleCodes);
    }

    @Override
    public List<Org> findAllParentByRuleCodes(List<String> ruleCodes) {
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return null;
        }
        Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Validate.notNull((Object)treeRuleCodeStrategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565", (Object[])new Object[0]);
        Set ruleCodeAll = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(3, ruleCodes);
        if (CollectionUtils.isEmpty((Collection)ruleCodeAll)) {
            return null;
        }
        return this.findByRuleCodesAndEnableStatus(new ArrayList<String>(ruleCodeAll), null);
    }

    @Override
    public List<Org> findAllParentByOrgCodesExcludeSelf(List<String> orgCodes) {
        List<Org> orgs = this.findByOrgCodes(orgCodes);
        if (CollectionUtils.isEmpty(orgs)) {
            return null;
        }
        List ruleCodes = orgs.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Set ruleCodeAll = treeRuleCodeStrategy.findParentRuleCodesByRuleCodesExcludeSelf(3, ruleCodes);
        if (CollectionUtils.isEmpty((Collection)ruleCodeAll)) {
            return null;
        }
        return this.findByRuleCodesAndEnableStatus(new ArrayList<String>(ruleCodeAll), null);
    }

    @Override
    public Org findParentById(String id) {
        Org current = this.findDetailsById(id);
        if (Objects.isNull((Object)current)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)current.getParentCode())) {
            return null;
        }
        return this.findByOrgCode(current.getParentCode());
    }

    @Override
    public Org findParentByOrgCode(String orgCode) {
        Org current = this.findByOrgCode(orgCode);
        if (Objects.isNull((Object)current)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)current.getParentCode())) {
            return null;
        }
        return this.findByOrgCode(current.getParentCode());
    }

    @Override
    public List<Org> findAllChildrenByOrgCodes(Pageable pageable, List<String> orgCodes) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        List<String> ruleCodes = this.orgRepository.findRuleCodeByOrgCodes(orgCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), ruleCodes, pageable.getPageNumber(), pageable.getPageSize()});
        List graph = (List)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            Page<Org> page = this.orgRepository.findChildrenByRuleCodes(pageable, ruleCodes, TenantUtils.getTenantCode());
            if (null == page) {
                return null;
            }
            graph = page.getRecords();
            cache.put((Object)cacheKey, (Object)graph);
        }
        return graph;
    }

    @Override
    public List<Org> findByConditions(OrgPaginationDto dto) {
        String cacheKey;
        List<Org> graph;
        if (dto == null) {
            dto = new OrgPaginationDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)dto.getTenantCode())) {
            sb.append(dto.getTenantCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEnableStatus())) {
            sb.append(dto.getEnableStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getParentCode())) {
            sb.append(dto.getParentCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgType())) {
            sb.append(dto.getOrgType());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgCode())) {
            sb.append(dto.getOrgCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgName())) {
            sb.append(dto.getOrgName());
        }
        if ((graph = (List<Org>)cache.getIfPresent((Object)(cacheKey = sb.toString()))) == null) {
            graph = this.orgRepository.findByConditions(dto);
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    public List<Org> findByParentCode(String orgCode) {
        return this.findChildrenByOrgCode(orgCode);
    }

    @Override
    @Transactional
    public void updateRuleCode() {
        this.orgRepository.updateOrphanParentCodeNull(TenantUtils.getTenantCode());
        List<Org> topList = this.orgRepository.findListWithoutParentCode(TenantUtils.getTenantCode());
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < topList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(topList.get(i).getOrgCode(), treeRuleCodeStrategy.generateByNum(3, i + 1), 1);
        }
    }

    @Override
    public List<Org> findAllChildrenByOrgTypes(List<String> orgTypes) {
        if (CollectionUtils.isEmpty(orgTypes)) {
            return null;
        }
        List<String> ruleCodes = this.orgRepository.findRuleCodeByOrgTypes(orgTypes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return null;
        }
        return this.findChildrenByRuleCode(ruleCodes);
    }

    @Override
    public List<Org> findChildrenByRuleCode(List<String> ruleCodes) {
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), ruleCodes});
        List<Org> graph = (List<Org>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgRepository.findChildrenByRuleCode(ruleCodes, TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    public List<Org> findByRuleCodesAndEnableStatus(List<String> ruleCodes, EnableStatusEnum enable) {
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), ruleCodes, enable != null ? enable.getCode() : null});
        List<Org> graph = (List<Org>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.orgRepository.findByRuleCodesAndEnableStatus(ruleCodes, enable, TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    private void updateCurAndChildrenRuleCode(String orgCode, String ruleCode, int levelNum) {
        Org org = this.orgRepository.findDetailsByCode(orgCode, TenantUtils.getTenantCode());
        if (org == null) {
            return;
        }
        org.setRuleCode(ruleCode);
        org.setLevelNum(levelNum);
        this.orgRepository.updateById((Object)org);
        List<Org> childrenList = this.orgRepository.findChildrenListByParentCode(orgCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < childrenList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(childrenList.get(i).getOrgCode(), ruleCode + treeRuleCodeStrategy.generateByNum(3, i + 1), levelNum + 1);
        }
    }

    private Org updateForm(Org org) {
        org.setTenantCode(TenantUtils.getTenantCode());
        this.updateValidation(org);
        String currentId = org.getId();
        Org current = (Org)((Object)this.orgRepository.getById((Serializable)((Object)currentId)));
        current = (Org)((Object)Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        Validate.isTrue((boolean)Objects.equals(org.getOrgCode(), current.getOrgCode()), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        int levelNum = 1;
        String parentCode = org.getParentCode();
        String parentRuleCode = null;
        List<Object> children = Lists.newArrayList();
        List childrenDto = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)parentCode)) {
            Org parent = this.findByOrgCode(parentCode);
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Validate.isTrue((!parent.getRuleCode().startsWith(current.getRuleCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u662f\u5f53\u524d\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u7ec4\u7ec7", (Object[])new Object[0]);
            levelNum = parent.getLevelNum() + 1;
            parentRuleCode = parent.getRuleCode();
            children = this.orgRepository.findByParentCode(parentCode, TenantUtils.getTenantCode());
        } else {
            children = this.orgRepository.findByParentCodeIsNull(TenantUtils.getTenantCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            childrenDto = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)children, Org.class, TreeDto.class, HashSet.class, ArrayList.class, new String[0]);
        }
        String oldParentCode = current.getParentCode();
        BeanUtils.copyProperties((Object)((Object)org), (Object)((Object)current), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode", "ruleCode"});
        Date now = new Date();
        String account = this.loginUserService.getLoginAccountName();
        current.setLevelNum(levelNum);
        current.setModifyAccount(account);
        current.setModifyTime(now);
        this.orgRepository.saveOrUpdate((Object)current);
        if (StringUtils.isBlank((CharSequence)org.getParentCode())) {
            this.orgRepository.setParentCodeNull(org.getId());
        }
        if (!Objects.equals(org.getEnableStatus(), current.getEnableStatus())) {
            if (Objects.equals(org.getEnableStatus(), EnableStatusEnum.DISABLE.getCode())) {
                this.disableBatch(Lists.newArrayList((Object[])new String[]{org.getId()}));
            } else if (Objects.equals(org.getEnableStatus(), EnableStatusEnum.ENABLE.getCode())) {
                this.enableBatch(Lists.newArrayList((Object[])new String[]{org.getId()}));
            }
        }
        if (!Objects.equals(parentCode, oldParentCode)) {
            Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
            TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
            Validate.notNull((Object)treeRuleCodeStrategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565", (Object[])new Object[0]);
            String ruleCode = treeRuleCodeStrategy.generate(3, parentRuleCode, childrenDto);
            this.updateRuleCodeAllChildren(org.getOrgCode(), ruleCode, levelNum);
            current.setRuleCode(ruleCode);
        }
        OrgEventDto orgEventDto = (OrgEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, OrgEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        orgEventDto.setOldParentCode(Optional.ofNullable(oldParentCode).orElse(""));
        orgEventDto.setParentCode(Optional.ofNullable(org.getParentCode()).orElse(""));
        SerializableBiConsumer & Serializable sf = OrgEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)orgEventDto, OrgEventListener.class, (SerializableBiConsumer)sf);
        OrgLogEventDto orgLogEventDto = new OrgLogEventDto();
        orgLogEventDto.setNewest((OrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, OrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        orgLogEventDto.setOriginal((OrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)org, OrgVo.class, HashSet.class, ArrayList.class, new String[0]));
        SerializableBiConsumer & Serializable onUpdate = OrgLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)orgLogEventDto, OrgLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return current;
    }

    private Org createForm(Org org) {
        Date now = new Date();
        String account = this.loginUserService.getLoginAccountName();
        org.setCreateAccount(account);
        org.setModifyAccount(account);
        org.setTenantCode(TenantUtils.getTenantCode());
        org.setCreateTime(now);
        org.setModifyTime(now);
        org.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        org.setEnableStatus(null != org.getEnableStatus() ? org.getEnableStatus() : EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)org.getOrgCode())) {
            String code = (String)this.generateCodeService.generateCode("ZZ", 1).get(0);
            org.setOrgCode(code);
        } else {
            Org exits = this.findByOrgCode(org.getOrgCode());
            Validate.isTrue((exits == null ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
        int levelNum = 1;
        if (StringUtils.isNotEmpty((CharSequence)org.getParentCode())) {
            Org parent = this.orgRepository.findDetailsByCode(org.getParentCode(), TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
            levelNum = parent.getLevelNum() + 1;
        }
        org.setParentCode(Optional.ofNullable(org.getParentCode()).orElse(""));
        String parentCode = org.getParentCode();
        String ruleCode = this.getRuleCodeByParentCode(parentCode);
        org.setRuleCode(ruleCode);
        org.setLevelNum(levelNum);
        String orgType = org.getOrgType();
        if (StringUtils.isBlank((CharSequence)orgType)) {
            for (OrgTypeEnum value : OrgTypeEnum.values()) {
                String order = value.getOrder();
                Integer integer = Integer.valueOf(order);
                if (integer != levelNum) continue;
                org.setOrgType(value.getDictCode());
            }
        }
        this.createValidation(org);
        return org;
    }

    private void createValidation(Org org) {
        Validate.notNull((Object)((Object)org), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)org.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        org.setId(null);
        Validate.notBlank((CharSequence)org.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)org.getOrgName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)org.getOrgType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String parentCode = org.getParentCode();
        if (StringUtils.isNotBlank((CharSequence)parentCode)) {
            Org parent = this.findByOrgCode(parentCode);
            Validate.notNull((Object)((Object)parent), (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)org.getOrgCode())) {
            Validate.isTrue((org.getOrgCode().length() < 32 ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u7f16\u7801\u4fe1\u606f\uff0c\u5728\u8fdb\u884c\u65b0\u589e\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        }
        Validate.isTrue((org.getOrgName().length() < 64 ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u65b0\u589e\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)org.getOrgDesc())) {
            Validate.isTrue((org.getOrgDesc() == null || org.getOrgDesc().length() < 128 ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u63cf\u8ff0\uff0c\u5728\u8fdb\u884c\u65b0\u589e\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        }
    }

    private void updateValidation(Org org) {
        Validate.notNull((Object)((Object)org), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)org.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)org.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((org.getOrgName().length() < 64 ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((org.getOrgDesc() == null || org.getOrgDesc().length() < 128 ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u63cf\u8ff0\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        String parentCode = org.getParentCode();
        if (StringUtils.isNotBlank((CharSequence)parentCode)) {
            Org parent = this.findByOrgCode(parentCode);
            Validate.notNull((Object)((Object)parent), (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        }
    }

    private List<String> findChildrenOrgCodeByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<String> ruleCodes = this.orgRepository.findRuleCodeByIds(ids);
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return null;
        }
        return this.orgRepository.findChildrenOrgCodeByRuleCodes(ruleCodes, TenantUtils.getTenantCode());
    }

    private void updateRuleCodeAllChildren(String orgCode, String ruleCode, int levelNum) {
        this.orgRepository.updateRuleCodeAndLevelNumByOrgCode(orgCode, ruleCode, levelNum, TenantUtils.getTenantCode());
        List<Org> children = this.orgRepository.findByParentCode(orgCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isNotEmpty(children)) {
            for (int i = 0; i < children.size(); ++i) {
                Org item = children.get(i);
                Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
                TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
                Validate.notNull((Object)treeRuleCodeStrategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565", (Object[])new Object[0]);
                this.updateRuleCodeAllChildren(item.getOrgCode(), ruleCode + treeRuleCodeStrategy.generateByNum(3, i + 1), levelNum + 1);
            }
        }
    }

    private String getRuleCodeByParentCode(String parentCode) {
        String parentRuleCode = null;
        if (StringUtils.isNotEmpty((CharSequence)parentCode)) {
            Org parent = this.orgRepository.findDetailsByCode(parentCode, TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            parentRuleCode = parent.getRuleCode();
        }
        List<Org> childrenListByParentCode = this.orgRepository.findChildrenListByParentCode(parentCode, TenantUtils.getTenantCode());
        ArrayList childrenDto = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenListByParentCode, Org.class, TreeDto.class, HashSet.class, ArrayList.class, new String[0]));
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        return treeRuleCodeStrategy.generate(3, parentRuleCode, (List)childrenDto);
    }
}

