/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryIdsDto;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/org/org"})
public class OrgController {
    private static final Logger log = LoggerFactory.getLogger(OrgController.class);
    @Autowired(required=false)
    private OrgService orgService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<Org>> findByConditions(@PageableDefault(value=50) Pageable pageable, OrgPaginationDto paginationDto) {
        try {
            Page<Org> result = this.orgService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7id/orgCode \u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/findDetailsByIdOrOrgCode"})
    public Result<Org> findDetailsByIdOrOrgCode(String id, String orgCode) {
        try {
            Org org = null;
            if (StringUtils.isNotBlank((CharSequence)id)) {
                org = this.orgService.findDetailsById(id);
            } else if (StringUtils.isNotBlank((CharSequence)orgCode)) {
                org = this.orgService.findByOrgCode(orgCode);
            }
            return Result.ok((Object)((Object)org));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309ids\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/findDetailsByIds"})
    public Result<List<Org>> findDetailsByIds(@RequestParam(value="ids") List<String> ids) {
        try {
            List<Org> orgs = this.orgService.findDetailsByIds(ids);
            return Result.ok(orgs);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u6216\u7ec4\u7ec7\u540d\u79f0\u67e5\u8be2")
    @GetMapping(value={"/findByOrgCodeLikeOrOrgNameLike"})
    public Result<List<Org>> findByOrgCodeLikeOrOrgNameLike(@RequestParam(value="orgCodeLikeorNameLike") String orgCodeLikeorNameLike) {
        try {
            return Result.ok(this.orgService.findByOrgCodeLikeOrOrgNameLike(orgCodeLikeorNameLike));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.orgService.deleteByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="PATCH")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.orgService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="PATCH")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.orgService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efaorg\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9org\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u57fa\u4e8e\uff08org\uff09\u6a21\u578b\u7684\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684orgJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PostMapping(value={""})
    public Result<Org> create(@RequestBody @ApiParam(name="org", value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efaorg\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9org\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u57fa\u4e8e\uff08org\uff09\u6a21\u578b\u7684\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684orgJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") Org org) {
        try {
            Org current = this.orgService.create(org);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u57fa\u4e8e\u6a21\u578b\uff08org\uff09\u7684\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684orgJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PatchMapping(value={""})
    public Result<Org> update(@RequestBody @ApiParam(name="org", value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u57fa\u4e8e\u6a21\u578b\uff08org\uff09\u7684\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684orgJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") Org org) {
        try {
            Org current = this.orgService.update(org);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e \u7ec4\u7ec7id/\u7ec4\u7ec7\u7f16\u7801 \u67e5\u8be2\u5168\u90e8\u4e0b\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @GetMapping(value={"/findAllChildrenByIdOrOrgCode"})
    public Result<List<Org>> findAllChildrenByIdOrOrgCode(String id, String orgCode) {
        try {
            List<Org> list = null;
            if (StringUtils.isNotBlank((CharSequence)id)) {
                list = this.orgService.findAllChildrenById(id);
            } else if (StringUtils.isNotBlank((CharSequence)orgCode)) {
                list = this.orgService.findAllChildrenByOrgCode(orgCode);
            }
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e \u7ec4\u7ec7id/\u7ec4\u7ec7\u7f16\u7801 \u67e5\u8be2\u5f53\u524d\u4e0b\u7ea7\u7ec4\u7ec7\u5217\u8868")
    @GetMapping(value={"/findChildrenByIdOrOrgCode"})
    public Result<List<Org>> findChildrenByIdOrOrgCode(String id, String orgCode) {
        try {
            List<Org> list = null;
            if (StringUtils.isNotBlank((CharSequence)id)) {
                list = this.orgService.findChildrenById(id);
            } else if (StringUtils.isNotBlank((CharSequence)orgCode)) {
                list = this.orgService.findChildrenByOrgCode(orgCode);
            }
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e \u7ec4\u7ec7id\u6216/\u7f16\u7801\u67e5\u8be2 \u5168\u90e8\u4e0a\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @GetMapping(value={"/findAllParentByIdOrOrgCode"})
    public Result<List<Org>> findAllParentByIdOrOrgCode(String id, String orgCode) {
        try {
            List<Org> list = null;
            if (StringUtils.isNotBlank((CharSequence)id)) {
                list = this.orgService.findAllParentById(id);
            } else if (StringUtils.isNotBlank((CharSequence)orgCode)) {
                list = this.orgService.findAllParentByOrgCode(orgCode);
            }
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id/\u7ec4\u7ec7orgCode \u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u7684\u76f4\u63a5\u4e0a\u7ea7\u7ec4\u7ec7")
    @GetMapping(value={"/findParentByIdOrOrgCode"})
    public Result<Org> findParentByIdOrOrgCode(String id, String orgCode) {
        try {
            Org parent = null;
            if (StringUtils.isNotBlank((CharSequence)id)) {
                parent = this.orgService.findParentById(id);
            } else if (StringUtils.isNotBlank((CharSequence)orgCode)) {
                parent = this.orgService.findParentByOrgCode(orgCode);
            }
            return Result.ok((Object)((Object)parent));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u53ea\u67e5\u8be2\u6307\u5b9a\u6761\u6570")
    @GetMapping(value={"/findAllChildrenByOrgCodes"})
    public Result<List<Org>> findAllChildrenByOrgCodes(@PageableDefault(value=50) Pageable pageable, @RequestParam(value="orgCodes") List<String> orgCodes) {
        try {
            List<Org> list = this.orgService.findAllChildrenByOrgCodes(pageable, orgCodes);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7\uff08\u4e0d\u5206\u9875\uff0c\u6570\u636e\u91cf\u5927\uff0c\u7ed9\u540e\u53f0\u7528\uff09(\u542f\u7528\u72b6\u6001\u3001\u7ec4\u7ec7\u7c7b\u578b\u3001\u4e0a\u7ea7\u7f16\u7801\u7cbe\u786e\u67e5\u8be2\uff0c\u7ec4\u7ec7\u7f16\u7801\u3001\u540d\u79f0\u6a21\u7cca\u67e5\u8be2)")
    @GetMapping(value={"/findListByConditions"})
    public Result<List<Org>> findListByConditions(OrgPaginationDto dao) {
        try {
            List<Org> list = this.orgService.findByConditions(dao);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7")
    @GetMapping(value={"/findAll"})
    public Result<List<Org>> findAll() {
        try {
            OrgPaginationDto dao = new OrgPaginationDto();
            dao.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            List<Org> list = this.orgService.findByConditions(dao);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u964d\u7ef4\u7f16\u7801")
    @PatchMapping(value={"/updateRuleCode"})
    public Result<?> updateRuleCode() {
        try {
            this.orgService.updateRuleCode();
            return Result.ok((String)"\u91cd\u7f6e\u964d\u7ef4\u7f16\u7801\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u8fd9\u4e9b\u7ec4\u7ec7\uff08\u4e0d\u542b\u81ea\u5df1\uff09\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u7f16\u7801\uff0c\u5982\u679c\u53c2\u6570\u672c\u8eab\u6709\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u5219\u4f1a\u8fd4\u56de\u5904\u4e8e\u4e0a\u7ea7\u7684\u7ec4\u7ec7\u7f16\u7801")
    @GetMapping(value={"/findAllParentOrgCodeExcludeSelf"})
    public Result<List<String>> findAllParentOrgCodeExcludeSelf(@RequestParam(value="orgCodes") List<String> orgCodes) {
        try {
            List<Org> list = this.orgService.findAllParentByOrgCodesExcludeSelf(orgCodes);
            List parentOrgCodes = null;
            if (CollectionUtils.isNotEmpty(list)) {
                parentOrgCodes = list.stream().map(Org::getOrgCode).collect(Collectors.toList());
            }
            return Result.ok(parentOrgCodes);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528\u7ec4\u7ec7\u914d\u9001\u6743\u9650")
    @PatchMapping(value={"enableAuthority"})
    public Result<?> enableAuthority(@RequestBody List<String> ids) {
        try {
            this.orgService.enableAuthority(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528\u7ec4\u7ec7\u914d\u9001\u6743\u9650")
    @PatchMapping(value={"disableAuthority"})
    public Result<?> disableAuthority(@RequestBody List<String> ids) {
        try {
            this.orgService.disableAuthority(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7")
    @PostMapping(value={"findByIds"})
    public Result<List<OrgVo>> findByIds(@RequestBody OrgQueryIdsDto dto) {
        try {
            List<OrgVo> list = this.orgService.findByIds(dto);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

