/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgTreeVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgTreeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u6811\u72b6\u7ed3\u6784\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/org/orgTree"})
public class OrgTreeVoController {
    private static final Logger log = LoggerFactory.getLogger(OrgTreeVoController.class);
    @Autowired(required=false)
    private OrgTreeVoService orgTreeVoService;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7\u6811\u5f62\u7ed3\u6784\uff08\u7ed9\u540e\u53f0\u4f7f\u7528\uff09\uff0c\u65e0\u7b5b\u9009\u6761\u4ef6\uff0c\u5168\u90e8\u8fd4\u56de\uff08\u5305\u542b\u505c\u7528\uff09")
    @GetMapping(value={"/findAllStruTree"})
    public Result<List<OrgTreeVo>> findAllStruTree(OrgPaginationDto orgPaginationDto) {
        try {
            List trees = this.orgTreeVoService.findAllStruTreeByCondition(orgPaginationDto);
            return Result.ok((Object)trees);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7\u6811\u5f62\u7ed3\u6784\uff08\u7ed9\u540e\u53f0\u4f7f\u7528\uff09\uff0c\u65e0\u7b5b\u9009\u6761\u4ef6\uff0c\u5168\u90e8\u8fd4\u56de\uff08\u5305\u542b\u505c\u7528\uff09")
    @GetMapping(value={"/findByOrgNameStruTree"})
    public Result<List<OrgTreeVo>> findByOrgNameStruTree(String orgName, String enableStatus) {
        try {
            List trees = this.orgTreeVoService.findByOrgNameStruTree(orgName, enableStatus);
            return Result.ok((Object)trees);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

