/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.deprecated.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgParentChildrenRedisVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgRedisVo;
import com.biz.crm.mdm.business.org.sdk.deprecated.vo.MdmOrgReloadRedisVo;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmOrgRedisController"})
@Deprecated
public class MdmOrgRedisController {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgRedisController.class);
    @Autowired(required=false)
    private OrgService orgService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @PostMapping(value={"/findRedisListByOrgCodeList"})
    public Result<List<MdmOrgRedisVo>> findRedisListByOrgCodeList(@RequestBody List<String> orgCodeList) {
        try {
            List vos = null;
            List<Org> list = this.orgService.findByOrgCodes(orgCodeList);
            if (CollectionUtils.isNotEmpty(list)) {
                vos = list.stream().map(item -> {
                    MdmOrgRedisVo vo = (MdmOrgRedisVo)this.nebulaToolkitService.copyObjectByBlankList((Object)item, MdmOrgRedisVo.class, HashSet.class, ArrayList.class, new String[0]);
                    if (Objects.nonNull((Object)item.getParent())) {
                        vo.setParentName(item.getParent().getOrgName());
                    }
                    return vo;
                }).collect(Collectors.toList());
            }
            return Result.ok(vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/findRedisOrgParentListByCodeList"})
    public Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgParentListByCodeList(@RequestBody List<String> orgCodeList) {
        try {
            ArrayList<MdmOrgParentChildrenRedisVo> result = new ArrayList<MdmOrgParentChildrenRedisVo>();
            List<Org> parents = this.orgService.findAllParentByOrgCodes(orgCodeList);
            if (CollectionUtils.isEmpty(parents)) {
                return Result.ok(result);
            }
            Set parentCodes = parents.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getParentCode())).map(Org::getParentCode).collect(Collectors.toSet());
            List<Org> parentNames = this.orgService.findByOrgCodes(Lists.newArrayList(parentCodes));
            Map<Object, Object> parentOrgCodeNameMap = new HashMap();
            if (CollectionUtils.isNotEmpty(parentNames)) {
                parentOrgCodeNameMap = parentNames.stream().collect(Collectors.toMap(Org::getOrgCode, Org::getOrgName));
            }
            HashMap finalParentOrgCodeNameMap = parentOrgCodeNameMap;
            List parentRedisVoList = parents.stream().map(item -> {
                MdmOrgRedisVo vo = (MdmOrgRedisVo)this.nebulaToolkitService.copyObjectByBlankList((Object)item, MdmOrgRedisVo.class, HashSet.class, ArrayList.class, new String[0]);
                if (StringUtils.isNotBlank((CharSequence)vo.getParentCode()) && finalParentOrgCodeNameMap.containsKey(vo.getParentCode())) {
                    vo.setParentName((String)finalParentOrgCodeNameMap.get(vo.getParentCode()));
                }
                return vo;
            }).collect(Collectors.toList());
            for (Org item2 : parents) {
                MdmOrgParentChildrenRedisVo redisVo = new MdmOrgParentChildrenRedisVo();
                redisVo.setOrgCode(item2.getOrgCode());
                redisVo.setList(parentRedisVoList.stream().filter(x -> item2.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
                result.add(redisVo);
            }
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/findRedisOrgChildrenListByCodeList"})
    public Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgChildrenListByCodeList(@RequestBody List<String> orgCodeList) {
        try {
            ArrayList<MdmOrgParentChildrenRedisVo> result = new ArrayList<MdmOrgParentChildrenRedisVo>();
            List<Org> children = this.orgService.findAllChildrenByOrgCodes(orgCodeList);
            if (CollectionUtils.isEmpty(children)) {
                return Result.ok(result);
            }
            List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(children, Org.class, MdmOrgRedisVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (Org item : children) {
                MdmOrgParentChildrenRedisVo redisVo = new MdmOrgParentChildrenRedisVo();
                redisVo.setOrgCode(item.getOrgCode());
                redisVo.setList(vos.stream().filter(x -> item.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
                result.add(redisVo);
            }
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/findRedisReloadList"})
    public Result<List<MdmOrgReloadRedisVo>> findRedisReloadList() {
        try {
            List<Object> vos = Lists.newArrayList();
            OrgPaginationDto paginationDto = new OrgPaginationDto();
            List<Org> all = this.orgService.findByConditions(paginationDto);
            if (CollectionUtils.isEmpty(all)) {
                return Result.ok((Object)vos);
            }
            Map<String, String> orgCodeNameMap = all.stream().collect(Collectors.toMap(Org::getOrgCode, Org::getOrgName));
            List redisList = all.stream().map(item -> {
                MdmOrgRedisVo copy = (MdmOrgRedisVo)this.nebulaToolkitService.copyObjectByBlankList((Object)item, MdmOrgRedisVo.class, HashSet.class, ArrayList.class, new String[0]);
                if (StringUtils.isNotEmpty((CharSequence)copy.getParentCode())) {
                    copy.setParentName((String)orgCodeNameMap.get(copy.getParentCode()));
                }
                return copy;
            }).collect(Collectors.toList());
            vos = redisList.stream().map(item -> {
                MdmOrgReloadRedisVo redisVo = new MdmOrgReloadRedisVo();
                redisVo.setOrgCode(item.getOrgCode());
                redisVo.setSelf(item);
                redisVo.setParentList(redisList.stream().filter(x -> item.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
                redisVo.setChildrenList(redisList.stream().filter(x -> x.getRuleCode().startsWith(item.getRuleCode())).collect(Collectors.toList()));
                return redisVo;
            }).collect(Collectors.toList());
            return Result.ok((Object)vos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

