/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.repository.OrgRepository;
import com.biz.crm.mdm.business.org.sdk.common.enums.SearchTypeEnum;
import com.biz.crm.mdm.business.org.sdk.dto.OrgTreeDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgLazyTreeVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrgLazyTreeVoServiceImpl
implements OrgLazyTreeVoService {
    @Autowired(required=false)
    private OrgRepository orgRepository;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Value(value="${crm.business.rule-code-length.org:}")
    private Integer ruleCodeLength;

    public Page<LazyTreeVo> findByConditions(Pageable pageable, TreeDto treeDto) {
        Org one;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Page<LazyTreeVo> page = new Page<LazyTreeVo>();
        ArrayList list = new ArrayList();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getExcludeCodeAndChildren()) && (one = this.orgRepository.findByOrgCode(treeDto.getExcludeCodeAndChildren(), TenantUtils.getTenantCode())) != null) {
            excludeRuleCode = one.getRuleCode();
        }
        if (!StringUtils.isEmpty((CharSequence)treeDto.getParentCode())) {
            page = this.orgRepository.findOrgLazyTreeListPage(pageable, treeDto.getEnableStatus(), null, treeDto.getParentCode(), null, null, excludeRuleCode, TenantUtils.getTenantCode());
            list.addAll(page.getRecords());
        } else if (!StringUtils.isEmpty((CharSequence)treeDto.getName())) {
            List<Org> likeList = this.orgRepository.findOrgCodeAndRuleCodeByEnableStatusOptAndOrgNameLike(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode());
            if (!CollectionUtils.isEmpty(likeList)) {
                TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
                Set parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(this.ruleCodeLength.intValue(), likeList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList()));
                page = this.orgRepository.findOrgLazyTreeListPage(pageable, treeDto.getEnableStatus(), null, null, null, new ArrayList<String>(parentRuleCodes), excludeRuleCode, TenantUtils.getTenantCode());
                list.addAll(page.getRecords());
            }
        } else {
            page = this.orgRepository.findOrgLazyTreeListPage(pageable, treeDto.getEnableStatus(), true, null, null, null, excludeRuleCode, TenantUtils.getTenantCode());
            list.addAll(page.getRecords());
        }
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(item -> item.setHasChild(Boolean.valueOf(BooleanEnum.TRUE.getNumStr().equalsIgnoreCase(String.valueOf(item.getHasChildFlag())))));
            List lazyTreeVos = TreeUtil.generateLazyTreeByParentCode(list);
            page.setRecords(lazyTreeVos);
            return page;
        }
        return new Page();
    }

    public Page<LazyTreeVo> findOrgByConditions(Pageable pageable, OrgTreeDto treeDto) {
        Page<LazyTreeVo> page;
        Validate.notNull((Object)treeDto, (String)"\u6ca1\u6709\u4f20\u5165\u641c\u7d22\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)treeDto.getSearchType(), (String)"\u6ca1\u6709\u4f20\u5165\u641c\u7d22\u7c7b\u578b!", (Object[])new Object[0]);
        if (SearchTypeEnum.SEARCH.getDictCode().equals(treeDto.getSearchType())) {
            page = this.findByConditions(pageable, (TreeDto)treeDto);
        } else {
            pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
            ArrayList list = new ArrayList();
            if (StringUtils.isBlank((CharSequence)treeDto.getParentCode())) {
                page = this.orgRepository.findOrgLazyTreeListPage(pageable, treeDto.getEnableStatus(), true, null, null, null, null, TenantUtils.getTenantCode());
                list.addAll(page.getRecords());
            } else {
                page = this.orgRepository.findOrgLazyTreeListPage(pageable, treeDto.getEnableStatus(), null, treeDto.getParentCode(), null, null, null, TenantUtils.getTenantCode());
                list.addAll(page.getRecords());
            }
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(item -> item.setHasChild(Boolean.valueOf(BooleanEnum.TRUE.getNumStr().equalsIgnoreCase(String.valueOf(item.getHasChildFlag())))));
                page.setRecords(list);
                return page;
            }
        }
        return page;
    }

    public List<LazyTreeVo> findByTreeDto(TreeDto treeDto) {
        Org one;
        ArrayList<LazyTreeVo> list = new ArrayList<LazyTreeVo>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getExcludeCodeAndChildren()) && (one = this.orgRepository.findByOrgCode(treeDto.getExcludeCodeAndChildren(), TenantUtils.getTenantCode())) != null) {
            excludeRuleCode = one.getRuleCode();
        }
        if (!StringUtils.isEmpty((CharSequence)treeDto.getParentCode())) {
            list.addAll(this.orgRepository.findOrgLazyTreeList(treeDto.getEnableStatus(), null, treeDto.getParentCode(), null, null, excludeRuleCode, TenantUtils.getTenantCode()));
        } else if (!StringUtils.isEmpty((CharSequence)treeDto.getName())) {
            List<Org> likeList = this.orgRepository.findOrgCodeAndRuleCodeByEnableStatusOptAndOrgNameLike(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode());
            if (!CollectionUtils.isEmpty(likeList)) {
                TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
                Set parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(this.ruleCodeLength.intValue(), likeList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList()));
                return this.orgRepository.findOrgLazyTreeList(treeDto.getEnableStatus(), null, null, null, new ArrayList<String>(parentRuleCodes), excludeRuleCode, TenantUtils.getTenantCode());
            }
        } else {
            list.addAll(this.orgRepository.findOrgLazyTreeList(treeDto.getEnableStatus(), true, null, null, null, excludeRuleCode, TenantUtils.getTenantCode()));
        }
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(item -> item.setHasChild(Boolean.valueOf(BooleanEnum.TRUE.getNumStr().equalsIgnoreCase(String.valueOf(item.getHasChildFlag())))));
            return TreeUtil.generateLazyTreeByParentCode(list);
        }
        return new ArrayList<LazyTreeVo>();
    }
}

