/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.org.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.repository.OrgRepository;
import com.biz.crm.mdm.business.org.local.service.OrgPermissionService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPermissionDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgPermissionServiceImpl
implements OrgPermissionService {
    @Autowired(required=false)
    private OrgRepository repository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void create(OrgPermissionDto dto) {
        this.createValidate(dto);
        Org org = this.createFrom(dto);
        this.repository.save((Object)org);
    }

    private Org createFrom(OrgPermissionDto dto) {
        Org org = (Org)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Org.class, HashSet.class, ArrayList.class, new String[0]));
        org.setParentName(dto.getParentName());
        org.setOrgType(dto.getOrgType());
        org.setOrgCode(dto.getOrgCode());
        org.setAuthority(dto.getAuthority());
        org.setOrgName(dto.getOrgName());
        org.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        org.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        org.setTenantCode(TenantUtils.getTenantCode());
        Org entity = this.repository.findLevelNumByName(dto.getParentName());
        int levelNum = 1;
        if (entity != null) {
            levelNum = entity.getLevelNum() + 1;
            org.setParentCode(entity.getOrgCode());
        }
        org.setLevelNum(levelNum);
        return org;
    }

    @Override
    @Transactional
    public void update(OrgPermissionDto dto) {
        this.editValidate(dto);
        Org org = (Org)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Org.class, HashSet.class, ArrayList.class, new String[0]));
        this.repository.updateById((Object)org);
    }

    @Override
    @Transactional
    public void deleteByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.repository.removeByIds(ids);
    }

    @Override
    @Transactional
    public void enable(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.repository.enableIds(ids);
    }

    @Override
    @Transactional
    public void disable(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.repository.disable(ids);
    }

    private void editValidate(OrgPermissionDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u8bf7\u6c42id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgType(), (String)"\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getParentName(), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAuthority(), (String)"\u7ec4\u7ec7\u914d\u9001\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void createValidate(OrgPermissionDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgType(), (String)"\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getParentName(), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAuthority(), (String)"\u7ec4\u7ec7\u914d\u9001\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

