package com.biz.crm.mdm.business.org.sdk.service;

import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;

import java.util.List;
import java.util.Set;

/**
 * 组织职位关系接口
 *
 * @author pengxi
 * @date 2021/11/23
 */
public interface OrgPositionVoService {

  /**
   * 根据职位查询组织信息
   *
   * @param positionCode
   * @return
   */
  OrgVo findByPositionCode(String positionCode);

  /**
   * 根据组织编码查询职位编码集合
   *
   * @param orgCodes 组织机构编码
   * @return 职位编码集合
   */
  Set<String> findPositionCodesByOrgCodes(List<String> orgCodes);

  /**
   * 根据职位集合查询组织编码集合
   *
   * @param positionCodes 职位集合
   * @return 组织职位关联信息集合
   */
  List<OrgPositionVo> findByPositionCodes(List<String> positionCodes);

  /**
   * 根据组织编码查询组织职位集合
   *
   * @param orgCodes 组织机构编码
   * @return 组织职位集合
   */
  List<OrgPositionVo> findByOrgCodes(List<String> orgCodes);
}
