package com.biz.crm.mdm.business.org.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 组织分页查询dto
 *
 * @author hecheng
 * @date 202/09/27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织分页查询dto")
public class OrgPaginationDto {

  private String id;
  /**
   *
   */
  private String tenantCode;

  /**
   * 编码名称模糊搜索
   */
  @ApiModelProperty("编码名称模糊搜索")
  private String keyword;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;
  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;
  /**
   * 销售组织编码
   */
  @ApiModelProperty("销售组织编码")
  private String salesOrgCode;

  /**
   * 销售组织名称
   */
  @ApiModelProperty("销售组织名称")
  private String salesOrgName;
  /**
   * 组织类型
   */
  @ApiModelProperty("组织类型（字典mdm_org_type）")
  private String orgType;
  /**
   * 组织名称/组织编码
   */
  @ApiModelProperty("组织名称/组织编码")
  private String codeOrName;

  /**
   * 上级组织编码
   */
  @ApiModelProperty("上级组织编码")
  private String parentCode;

  /**
   * 规则code查询用
   */
  @ApiModelProperty("对应SAP组织编码成本中心编码")
  private String ruleCode;
  /**
   * 启用禁用
   */
  @ApiModelProperty("启用禁用")
  private String enableStatus;
  /**
   * 组织类型集合
   */
  @ApiModelProperty("组织类型集合")
  private List<String> orgTypeList;
  /**
   * 对应SAP组织编码，模糊查询
   */
  @ApiModelProperty("对应SAP组织编码，模糊查询")
  private String sapOrgCode;
  /**
   * 对应SAP组织编码利润中心编码，模糊查询
   */
  @ApiModelProperty("对应SAP组织编码利润中心编码，模糊查询")
  private String sapProfitOrgCode;
  /**
   * 对应SAP组织编码成本中心编码，模糊查询
   */
  @ApiModelProperty("对应SAP组织编码成本中心编码，模糊查询")
  private String sapCostOrgCode;
  /**
   * 排除当前组织（及全部下级组织）
   */
  @ApiModelProperty("排除当前组织（及全部下级组织）")
  private String excludeAllChildrenOrgCode;
  /**
   * 只查询当前组织（及全部下级组织）
   */
  @ApiModelProperty("只查询当前组织（及全部下级组织）")
  private String includeAllChildrenOrgCode;
  /**
   * 企业组织编码，查询这个组织及全部下级企业组织（不含当前）
   */
  @ApiModelProperty("企业组织编码，查询这个组织及全部下级企业组织（不含当前）")
  private String includeAllChildrenOrgCodeExcludeSelf;
  /**
   * 排除当前组织（及全部下级组织）
   */
  @ApiModelProperty("排除当前组织（及全部下级组织）")
  private String excludeAllChildrenRuleCode;
  /**
   * 只查询当前组织（及全部下级组织）
   */
  @ApiModelProperty("只查询当前组织（及全部下级组织）")
  private String includeAllChildrenRuleCode;

  /**
   * 企业组织编码集合，查询这些组织及全部下级企业组织（含当前组织）
   */
  @ApiModelProperty("企业组织编码集合，查询这些组织及全部下级企业组织（含当前组织）")
  private List<String> allChildrenOrgCodesIncludeSelf;
  /**
   * 企业组织编码集合，查询这些组织的全部下级组织（不含当前，如果参数本身有上下级关系，则要返回处于下级的组织）
   */
  @ApiModelProperty("企业组织编码集合，查询这些组织的全部下级组织（不含当前，如果参数本身有上下级关系，则要返回处于下级的组织）")
  private List<String> allChildrenOrgCodesExcludeSelf;
  /**
   * 企业组织编码集合，查询这些组织的全部下级组织（不含参数中的任意一个组织）
   */
  @ApiModelProperty("企业组织编码集合，查询这些组织的全部下级组织（不含参数中的任意一个组织）")
  private List<String> allChildrenOrgCodesExcludeAnySelf;

  /**
   * 企业组织编码集合
   */
  @ApiModelProperty("企业组织编码集合")
  private List<String> orgCodes;
  /**
   * 回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据
   */
  @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
  private String selectedCode;
  /**
   * 回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据
   */
  @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
  private List<String> selectedCodes;
}
