package com.biz.crm.mdm.business.org.sdk.event;

import com.biz.crm.mdm.business.org.sdk.dto.OrgEventBatchDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import java.util.List;

/**
 * 组织事件监听器
 *
 * @author hecheng
 * @date 2021/09/29
 */
public interface OrgEventListener extends NebulaEvent {

  /**
   * 当删除一批组织时触发删除事件
   *
   * @param orgCodes
   */
  void onDelete(List<String> orgCodes);

  /**
   * 当删除一批组织时触发删除事件
   *
   * @param orgEventBatchDto
   */
  void onDeleteBatch(OrgEventBatchDto orgEventBatchDto);

  /**
   * 当启用一批组织时触发批量启用事件
   *
   * @param orgEventBatchDto
   */
  void onEnableBatch(OrgEventBatchDto orgEventBatchDto);

  /**
   * 当禁用一批组织时触发批量禁用事件
   *
   * @param orgEventBatchDto
   */
  void onDisableBatch(OrgEventBatchDto orgEventBatchDto);

  /**
   * 当修改组织时触发删除事件
   *
   * @param orgEventDto
   */
  void onUpdate(OrgEventDto orgEventDto);
}
