package com.biz.crm.mdm.business.org.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;

/**
 * 组织表返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织表")
public class OrgVo extends TenantFlagOpVo {
  private static final long serialVersionUID = 7385493313870750219L;
  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;
  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 销售组织编码
   */
  @ApiModelProperty("销售组织编码")
  private String salesOrgCode;

  /**
   * 销售组织名称
   */
  @TableField(value = "sales_org_name")
  private String salesOrgName;

  /**
   * 销售区域编码
   */
  @ApiModelProperty("销售区域编码")
  private String salesRegionCode;

  /**
   * 销售区域名称
   */
  @ApiModelProperty("销售区域名称")
  private String salesRegionName;

  /**
   * 自定组织编码
   */
  @ApiModelProperty("自定组织编码")
  private String customOrgCode;

  /**
   * 自定组织名称
   */
  @ApiModelProperty(value = "custom_org_name")
  private String customOrgName;

  /**
   * 组织级别
   */
  @ApiModelProperty(value = "org_level")
  private String orgLevel;
  /**
   * 组织类型
   */
  @ApiModelProperty("组织类型（字典mdm_org_type）")
  private String orgType;
  /**
   * 组织类型name
   */
  @ApiModelProperty("组织类型（orgType字段经过数据字典翻译后的值）")
  private String orgTypeName;
  /**
   * 组织描述
   */
  @ApiModelProperty("组织描述")
  private String orgDesc;
  /**
   * 上级组织编码
   */
  @ApiModelProperty("上级组织编码")
  private String parentCode;
  /**
   * 对应SAP组织编码
   */
  @ApiModelProperty("对应SAP组织编码")
  private String sapOrgCode;
  /**
   * 对应SAP组织编码利润中心编码
   */
  @ApiModelProperty("对应SAP组织编码利润中心编码")
  private String sapProfitOrgCode;
  /**
   * 对应SAP组织编码成本中心编码
   */
  @ApiModelProperty("对应SAP组织编码成本中心编码")
  private String sapCostOrgCode;

  @ApiModelProperty("业态编码")
  private String businessFormatCode;

  @ApiModelProperty("业态名称")
  private String businessFormatName;

  /**
   * 上级组织名称
   */
  @ApiModelProperty("上级组织名称")
  private String parentName;

  /**
   * 规则code查询用
   */
  @ApiModelProperty("对应SAP组织编码成本中心编码")
  private String ruleCode;

  /**
   * 层级等级查询用
   */
  @ApiModelProperty("层级等级查询用")
  private Integer levelNum;
  /**
   * 子节点
   */
  @ApiModelProperty("fu")
  private OrgVo parent;
  /**
   * 子节点
   */
  @ApiModelProperty("子节点")
  private List<OrgVo> children;
}
