package com.biz.crm.mdm.business.org.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 组织表返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织表")
public class OrgVo extends TenantFlagOpVo {
  private static final long serialVersionUID = 7385493313870750219L;
  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;
  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;
  /**
   * 组织类型
   */
  @ApiModelProperty("组织类型（字典mdm_org_type）")
  private String orgType;
  /**
   * 组织类型name
   */
  @ApiModelProperty("组织类型（orgType字段经过数据字典翻译后的值）")
  private String orgTypeName;
  /**
   * 组织描述
   */
  @ApiModelProperty("组织描述")
  private String orgDesc;
  /**
   * 上级组织编码
   */
  @ApiModelProperty("上级组织编码")
  private String parentCode;
  /**
   * 对应SAP组织编码
   */
  @ApiModelProperty("对应SAP组织编码")
  private String sapOrgCode;
  /**
   * 对应SAP组织编码利润中心编码
   */
  @ApiModelProperty("对应SAP组织编码利润中心编码")
  private String sapProfitOrgCode;
  /**
   * 对应SAP组织编码成本中心编码
   */
  @ApiModelProperty("对应SAP组织编码成本中心编码")
  private String sapCostOrgCode;
  /**
   * 上级组织名称
   */
  @ApiModelProperty("上级组织名称")
  private String parentName;

  /**
   * 规则code查询用
   */
  @ApiModelProperty("对应SAP组织编码成本中心编码")
  private String ruleCode;

  /**
   * 层级等级查询用
   */
  @ApiModelProperty("层级等级查询用")
  private Integer levelNum;
  /**
   * 子节点
   */
  @ApiModelProperty("fu")
  private OrgVo parent;
  /**
   * 子节点
   */
  @ApiModelProperty("子节点")
  private List<OrgVo> children;
}
