package com.biz.crm.mdm.business.org.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 组织事件dto
 *
 * @author hecheng pengxi
 * @date 202/09/27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织事件dto")
public class OrgEventDto extends TenantDto implements NebulaEventDto {

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;
  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;
  /**
   * 组织类型
   */
  @ApiModelProperty("组织类型（字典mdm_org_type）")
  private String orgType;

  /**
   * 上级组织编码
   */
  @ApiModelProperty("上级组织编码")
  private String parentCode;

  /**
   * 改变之前的上级组织编码
   */
  @ApiModelProperty("改变之前的上级组织编码")
  private String oldParentCode;

  /**
   * 规则code查询用
   */
  @ApiModelProperty("规则code查询用")
  private String ruleCode;


}
