package com.biz.crm.mdm.business.org.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.org.sdk.dto.OrgTreeDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author hefan
 */
public interface OrgLazyTreeVoService {

  /**
   * 组织懒加载树  带分页的
   *
   * @param treeDto
   * @return
   */
  Page<LazyTreeVo> findByConditions(Pageable pageable, TreeDto treeDto);

  /**
   * （最新的）搜索框输入时组织懒加载树分页,点击时展示平级分页
   * 传入搜索框输入标识，或者点击标识(必传)
   * 1,搜索框输入标识 什么都不传返回第一层,传name模糊查询并且查询出所有上级再构建成树形
   * 2,点击标识 加载下级结构
   *
   * @param treeDto
   * @return
   */
  Page<LazyTreeVo> findOrgByConditions(Pageable pageable, OrgTreeDto treeDto);

  /**
   * 组织懒加载树
   * @param treeDto
   * @return
   */
  List<LazyTreeVo> findByTreeDto(TreeDto treeDto);
}
