package com.biz.crm.mdm.business.org.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.org.sdk.dto.OrgPaginationDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author hecheng
 * @description: 组织vo service
 * @date 2021/9/29 上午11:25
 */
public interface OrgVoService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<OrgVo> findByConditions(Pageable pageable, OrgPaginationDto paginationDto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  OrgVo findDetailsById(String id);

  /**
   * 按组织code查询详情
   *
   * @param orgCode
   * @return
   */
  OrgVo findByOrgCode(String orgCode);

  /**
   * 按id集合查询
   *
   * @param ids
   * @return
   */
  List<OrgVo> findDetailsByIds(List<String> ids);

  /**
   * 按orgCode集合查询
   *
   * @param orgCodes
   * @return
   */
  List<OrgVo> findByOrgCodes(List<String> orgCodes);

  /**
   * 查询指定id下的所有子节点
   *
   * @param id
   * @return
   */
  List<OrgVo> findAllChildrenById(String id);

  /**
   * 查询指定orgCode下的所有子节点
   *
   * @param orgCode
   * @return
   */
  List<OrgVo> findAllChildrenByOrgCode(String orgCode);

  /**
   * 查询orgCodes下的所有子节点
   *
   * @param orgCodes
   * @return
   */
  List<OrgVo> findAllChildrenByOrgCodes(List<String> orgCodes);

  /**
   * 查询orgTypes下的所有子节点
   *
   * @param orgTypes
   * @return
   */
  List<OrgVo> findAllChildrenByOrgTypes(List<String> orgTypes);

  /**
   * 根据 组织编码查询 全部上级（含当前）组织列表
   *
   * @param orgCode
   * @return
   */
  List<OrgVo> findAllParentByOrgCode(String orgCode);

  /**
   * 根据 组织编码集合查询 全部上级（含当前）组织列表
   *
   * @param orgCodes
   * @return
   */
  List<OrgVo> findAllParentByOrgCodes(List<String> orgCodes);

  /**
   * 获取组织编码集合
   *
   * @param dto
   * @return
   */
  default Set<String> findByOrgQueryDto(OrgQueryDto dto) {
    return Sets.newHashSet();
  }

  /**
   * 根据获取组织对应的未删除的（同级|上级|下级，searchType = 0 同级 > 0 上级 < 0 下级，都包含自己 ）编码
   *
   * @param dto
   * @return k-orgCode,v-ruleCode
   */
  default Map<String, String> findByRelateOrgCodeQueryDto(RelateOrgCodeQueryDto dto) {
    return Maps.newHashMap();
  }
}
