package com.biz.crm.mdm.business.poi.local.deprecated.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.poi.sdk.deprecated.dto.MdmAmapPoiTypeTreeReqVo;
import com.biz.crm.mdm.business.poi.sdk.service.MapPoiTypeService;
import com.biz.crm.mdm.business.poi.sdk.vo.PoiTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 旧版-高德POI
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Slf4j
@RestController
@RequestMapping("/mdmAmapPoiTypeController")
@Api(tags = "MDM-高德POI分类")
@Deprecated
public class MdmAmapPoiTypeController {

  @Autowired(required = false)
  private MapPoiTypeService mapPoiTypeService;

  @ApiOperation("懒加载树")
  @PostMapping("/lazyTree")
  public Result<List<PoiTypeVo>> lazyTree(
      @RequestBody MdmAmapPoiTypeTreeReqVo reqVo) {
    try {
      reqVo = Optional.ofNullable(reqVo).orElse(new MdmAmapPoiTypeTreeReqVo());
      return Result.ok(mapPoiTypeService.findLazyTree(reqVo.getParentCode()));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
