package com.biz.crm.mdm.business.poi.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 高德POI
 *
 * @author sunx
 * @date 2021/10/9
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AmapPoi", description = "高德POI信息")
@Entity
@TableName("mdm_amap_poi")
@Table(
    name = "mdm_amap_poi",
    indexes = {@Index(name = "mdm_amap_poi_index1", columnList = "amap_id")})
@org.hibernate.annotations.Table(appliesTo = "mdm_amap_poi", comment = "高德POI信息")
public class AmapPoi extends TenantFlagOpEntity {
  private static final long serialVersionUID = 3132107471649324360L;

  /** 高德poi唯一ID */
  @ApiModelProperty("高德poi唯一ID")
  @Column(name = "amap_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '高德poi唯一ID'")
  private String amapId;

  /** 父POI的ID */
  @ApiModelProperty("父POI的ID 当前POI如果有父POI，则返回父POI的ID。可能为空")
  @Column(
      name = "parent_amap_id",
      length = 32,
      columnDefinition = "VARCHAR(32) COMMENT '父POI的ID 当前POI如果有父POI，则返回父POI的ID。可能为空'")
  private String parentAmapId;

  /** 名称 */
  @ApiModelProperty("名称")
  @Column(name = "poi_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '名称'")
  private String poiName;

  /** 兴趣点类型 */
  @ApiModelProperty("兴趣点类型 顺序为大类、中类、小类 例如：餐饮服务;中餐厅;特色/地方风味餐厅")
  @Column(
      name = "type_name",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '兴趣点类型 顺序为大类、中类、小类 例如：餐饮服务;中餐厅;特色/地方风味餐厅'")
  private String typeName;

  /** 兴趣点类型编码 */
  @ApiModelProperty("兴趣点类型编码 例如：050118")
  @Column(
      name = "type_code",
      length = 32,
      columnDefinition = "VARCHAR(32) COMMENT '兴趣点类型编码 例如：050118'")
  private String typeCode;

  /** 行业类型 */
  @ApiModelProperty("行业类型")
  @Column(name = "biz_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '行业类型'")
  private String bizType;

  /** 地址 */
  @ApiModelProperty("地址 东四环中路189号百盛北门")
  @Column(
      name = "address",
      length = 255,
      columnDefinition = "VARCHAR(255) COMMENT '地址 东四环中路189号百盛北门'")
  private String address;

  /** 经纬度 */
  @ApiModelProperty("经纬度 格式（维度,经度）")
  @Column(name = "location", length = 60, columnDefinition = "VARCHAR(60) COMMENT '经纬度 格式（维度,经度）'")
  private String location;

  /** 经度 */
  @ApiModelProperty("经度")
  @Column(name = "longitude", length = 32, columnDefinition = "decimal(12,8) COMMENT '经度'")
  private BigDecimal longitude;

  /** 维度 */
  @ApiModelProperty("维度")
  @Column(name = "latitude", length = 32, columnDefinition = "decimal(12,8) COMMENT '维度'")
  private BigDecimal latitude;

  /** 离中心点距离 */
  @ApiModelProperty("离中心点距离 单位：米；仅在周边搜索的时候有值返回")
  @Column(name = "distance", columnDefinition = "decimal(18,2) COMMENT '离中心点距离 单位：米；仅在周边搜索的时候有值返回'")
  private BigDecimal distance;

  /** POI的电话 */
  @ApiModelProperty("POI的电话")
  @Column(name = "tel", length = 128, columnDefinition = "VARCHAR(128) COMMENT 'POI的电话'")
  private String tel;

  /** 邮编 */
  @ApiModelProperty("邮编 extensions=all时返回")
  @Column(
      name = "post_code",
      length = 32,
      columnDefinition = "VARCHAR(32) COMMENT '邮编 extensions=all时返回'")
  private String postCode;

  /** POI的网址 */
  @ApiModelProperty("POI的网址  extensions=all时返回")
  @Column(
      name = "website",
      length = 500,
      columnDefinition = "VARCHAR(500) COMMENT 'POI的网址  extensions=all时返回'")
  private String website;

  /** POI的电子邮箱 */
  @ApiModelProperty("POI的电子邮箱  extensions=all时返回")
  @Column(
      name = "email",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT 'POI的电子邮箱  extensions=all时返回'")
  private String email;
  /** POI所在省份编码 */
  @ApiModelProperty("POI所在省份编码  extensions=all时返回")
  @Column(
      name = "amap_province_code",
      length = 32,
      columnDefinition = "VARCHAR(32) COMMENT 'POI所在省份编码  extensions=all时返回'")
  private String amapProvinceCode;

  /** POI所在省份名称 */
  @ApiModelProperty("POI所在省份名称 若是直辖市的时候，此处直接显示市名，例如北京市")
  @Column(
      name = "amap_province_name",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT 'POI所在省份名称 若是直辖市的时候，此处直接显示市名，例如北京市\"'")
  private String amapProvinceName;
  /** 城市编码 */
  @ApiModelProperty("城市编码 extensions=all时返回")
  @Column(
      name = "amap_city_code",
      length = 32,
      columnDefinition = "VARCHAR(32) COMMENT '城市编码 extensions=all时返回'")
  private String amapCityCode;
  /** 城市名 */
  @ApiModelProperty("城市名 若是直辖市的时候，此处直接显示市名，例如北京市")
  @Column(
      name = "amap_city_name",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '城市名 若是直辖市的时候，此处直接显示市名，例如北京市'")
  private String amapCityName;
  /** 区域编码 */
  @ApiModelProperty("区域编码 extensions=all时返回")
  @Column(
      name = "amap_district_code",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '区域编码 extensions=all时返回'")
  private String amapDistrictCode;
  /** 区域名称 */
  @ApiModelProperty("区域名称 区县级别的返回，例如朝阳区")
  @Column(
      name = "amap_district_name",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '区域名称 区县级别的返回，例如朝阳区'")
  private String amapDistrictName;
  /** CRM区县编码 */
  @ApiModelProperty("CRM区县编码")
  @Column(name = "region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT 'CRM区县编码'")
  private String regionCode;
  /** POI的入口经纬度 */
  @ApiModelProperty("POI的入口经纬度，格式（维度,经度）  extensions=all时返回，也可用作于POI的到达点")
  @Column(
      name = "entr_location",
      length = 60,
      columnDefinition =
          "VARCHAR(60) COMMENT 'POI的入口经纬度，格式（维度,经度）  extensions=all时返回，也可用作于POI的到达点'")
  private String entrLocation;
  /** POI的入口经度 */
  @ApiModelProperty("POI的入口经度")
  @Column(name = "entr_longitude", columnDefinition = "decimal(12,8) COMMENT 'POI的入口经度'")
  private BigDecimal entrLongitude;
  /** POI的入口维度 */
  @ApiModelProperty("POI的入口维度")
  @Column(name = "entr_latitude", columnDefinition = "decimal(12,8) COMMENT 'POI的入口维度'")
  private BigDecimal entrLatitude;

  /** POI导航id */
  @ApiModelProperty("POI导航id extensions=all时返回")
  @Column(
      name = "navi_poiid",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT 'POI导航id extensions=all时返回'")
  private String naviPoiid;

  /** 地理格ID */
  @ApiModelProperty("地理格ID extensions=all时返回")
  @Column(
      name = "grid_code",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '地理格ID extensions=all时返回'")
  private String gridCode;

  /** 别名 */
  @ApiModelProperty("别名  extensions=all时返回")
  @Column(
      name = "alias",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '别名 extensions=all时返回'")
  private String alias;

  /** 所在商圈 */
  @ApiModelProperty("所在商圈  extensions=all时返回")
  @Column(
      name = "business_area",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '所在商圈  extensions=all时返回'")
  private String businessArea;

  /** 该POI的特色内容 */
  @ApiModelProperty("该POI的特色内容 主要出现在美食类POI中，代表特色菜 例如“烤鱼,麻辣香锅,老干妈回锅肉extensions=all时返回")
  @Column(
      name = "tag",
      length = 500,
      columnDefinition =
          "VARCHAR(500) COMMENT '该POI的特色内容 主要出现在美食类POI中，代表特色菜 例如“烤鱼,麻辣香锅,老干妈回锅肉extensions=all时返回'")
  private String tag;

  /** 一张图片 */
  @ApiModelProperty("一张图片")
  @Column(name = "poi_photo", length = 500, columnDefinition = "VARCHAR(500) COMMENT '一张图片'")
  private String poiPhoto;
}
