package com.biz.crm.mdm.business.poi.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.poi.sdk.service.MapPoiCityService;
import com.biz.crm.mdm.business.poi.sdk.vo.PoiCityVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 高德poi城市
 *
 * @author sunx
 * @date 2021/10/9
 */
@Slf4j
@RestController
@RequestMapping("/v1/mappoi/mappoicity")
@Api(tags = "poi城市")
public class MapPoiCityController {

  @Autowired(required = false) private MapPoiCityService mapPoiCityService;

  /**
   * 懒加载poi城市树
   *
   * @param parentCode
   * @return
   */
  @ApiOperation("懒加载poi城市树")
  @GetMapping("/findLazyTree")
  public Result<List<PoiCityVo>> findLazyTree(
      @RequestParam(value = "parentCode", required = false) String parentCode) {
    try {
      return Result.ok(mapPoiCityService.findLazyTree(parentCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
