package com.biz.crm.mdm.business.poi.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.poi.sdk.service.MapPoiTypeService;
import com.biz.crm.mdm.business.poi.sdk.vo.PoiTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 高德poi分类
 *
 * @author sunx
 * @date 2021/10/9
 */
@Slf4j
@RestController
@RequestMapping("/v1/mappoi/mappoitype")
@Api(tags = "poi分类")
public class MapPoiTypeController {

  @Autowired(required = false) private MapPoiTypeService mapPoiTypeService;

  /**
   * 懒加载poi类型树
   *
   * @param parentCode
   * @return
   */
  @ApiOperation("懒加载poi类型树")
  @GetMapping("/findLazyTree")
  public Result<List<PoiTypeVo>> findLazyTree(
      @RequestParam(value = "parentCode", required = false) String parentCode) {
    try {
      return Result.ok(mapPoiTypeService.findLazyTree(parentCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
