package com.biz.crm.mdm.business.poi.local.deprecated.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.poi.sdk.deprecated.dto.MdmAmapPoiCityTreeReqVo;
import com.biz.crm.mdm.business.poi.sdk.service.MapPoiCityService;
import com.biz.crm.mdm.business.poi.sdk.vo.PoiCityVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 旧版-高德POI
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Slf4j
@RestController
@RequestMapping("/mdmAmapPoiCityController")
@Api(tags = "MDM-高德地图城市")
@Deprecated
public class MdmAmapPoiCityController {

  @Autowired(required = false)
  private MapPoiCityService mapPoiCityService;

  @ApiOperation("懒加载树")
  @PostMapping("/lazyTree")
  public Result<List<PoiCityVo>> lazyTree(
      @RequestBody MdmAmapPoiCityTreeReqVo reqVo) {
    try {
      reqVo = Optional.ofNullable(reqVo).orElse(new MdmAmapPoiCityTreeReqVo());
      return Result.ok(mapPoiCityService.findLazyTree(reqVo.getParentCode()));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
