package com.biz.crm.mdm.business.poi.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.poi.local.entity.AmapPoiCity;
import com.biz.crm.mdm.business.poi.local.mapper.AmapPoiCityMapper;
import com.biz.crm.mdm.business.poi.sdk.vo.PoiCityVo;
import java.util.List;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 高德poi城市
 *
 * @author sunx
 * @date 2021/10/9
 */
@Component
public class AmapPoiCityRepository extends ServiceImpl<AmapPoiCityMapper, AmapPoiCity> {

  /**
   * 获取所有一级poi城市信息
   *
   * @return
   */
  public List<PoiCityVo> findTopLevel() {
    return baseMapper.findByParentCode(StringUtils.EMPTY);
  }

  /**
   * 获取对应parentCode下级的poi城市信息
   *
   * @param parentCode
   * @return
   */
  public List<PoiCityVo> findByParentCode(String parentCode) {
    return baseMapper.findByParentCode(parentCode);
  }
}
