package com.biz.crm.mdm.business.poi.local.service.internal;

import com.biz.crm.mdm.business.poi.local.repository.AmapPoiCityRepository;
import com.biz.crm.mdm.business.poi.local.service.AmapPoiCityService;
import com.biz.crm.mdm.business.poi.sdk.vo.PoiCityVo;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 高德poi城市
 *
 * @author sunx
 * @date 2021/10/9
 */
@Service(value = "amapPoiCityService")
public class AmapPoiCityServiceImpl implements AmapPoiCityService {

  @Autowired(required = false) private AmapPoiCityRepository amapPoiCityRepository;

  @Autowired(required = false) private RegionVoService regionVoService;

  @Override
  public List<PoiCityVo> findLazyTree(String parentCode) {
    List<PoiCityVo> list;
    if (StringUtils.isBlank(parentCode)) {
      list = build(amapPoiCityRepository.findTopLevel());
    } else {
      list = build(amapPoiCityRepository.findByParentCode(parentCode));
    }
    if (CollectionUtils.isEmpty(list)) {
      return list;
    }
    List<String> regionCodeList =
        list.stream()
            .filter(x -> StringUtils.isNotBlank(x.getRegionCode()))
            .map(PoiCityVo::getRegionCode)
            .collect(Collectors.toList());
    if (CollectionUtils.isEmpty(regionCodeList)) {
      return list;
    }
    Map<String, String> regionCodeNameMap = regionVoService.findRegionCodeNameMap(regionCodeList);
    if (regionCodeNameMap != null) {
      list.forEach(
          item ->
              item.setRegionName(
                  regionCodeNameMap.getOrDefault(item.getRegionCode(), StringUtils.EMPTY)));
    }
    return list;
  }

  /**
   * 对集合属性组装，设置子级标识
   *
   * @param list
   * @return
   */
  private List<PoiCityVo> build(List<PoiCityVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return list;
    }
    for (PoiCityVo item : list) {
      item.setHasChildFlag(StringUtils.isBlank(item.getChildFlag()) ? 0 : 1);
      item.setHasChild(StringUtils.isNotBlank(item.getChildFlag()));
    }
    return list;
  }
}
