/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.poi.local.service.internal;

import com.biz.crm.mdm.business.poi.local.repository.AmapPoiCityRepository;
import com.biz.crm.mdm.business.poi.local.service.AmapPoiCityService;
import com.biz.crm.mdm.business.poi.sdk.vo.PoiCityVo;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="amapPoiCityService")
public class AmapPoiCityServiceImpl
implements AmapPoiCityService {
    @Autowired(required=false)
    private AmapPoiCityRepository amapPoiCityRepository;
    @Autowired(required=false)
    private RegionVoService regionVoService;

    @Override
    public List<PoiCityVo> findLazyTree(String parentCode) {
        List<PoiCityVo> list = StringUtils.isBlank((CharSequence)parentCode) ? this.build(this.amapPoiCityRepository.findTopLevel()) : this.build(this.amapPoiCityRepository.findByParentCode(parentCode));
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        List regionCodeList = list.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getRegionCode())).map(PoiCityVo::getRegionCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(regionCodeList)) {
            return list;
        }
        Map regionCodeNameMap = this.regionVoService.findRegionCodeNameMap(regionCodeList);
        if (regionCodeNameMap != null) {
            list.forEach(item -> item.setRegionName(regionCodeNameMap.getOrDefault(item.getRegionCode(), "")));
        }
        return list;
    }

    private List<PoiCityVo> build(List<PoiCityVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        for (PoiCityVo item : list) {
            item.setHasChildFlag(Integer.valueOf(StringUtils.isBlank((CharSequence)item.getChildFlag()) ? 0 : 1));
            item.setHasChild(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)item.getChildFlag())));
        }
        return list;
    }
}

