package com.biz.crm.mdm.business.poi.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 高德地图城市表
 *
 * @author sunx
 * @date 2021/10/9
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_amap_poi_city")
@ApiModel(value = "AmapPoiCity", description = "高德地图城市信息")
@Table(
    name = "mdm_amap_poi_city",
    indexes = {
      @Index(name = "mdm_amap_poi_city_index1", columnList = "amap_code"),
      @Index(name = "mdm_amap_poi_city_index2", columnList = "parent_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_amap_poi_city", comment = "高德地图城市信息")
public class AmapPoiCity extends TenantFlagOpEntity {
  private static final long serialVersionUID = 8998131233347185129L;

  @ApiModelProperty("高德城市编码")
  @Column(
      name = "amap_code",
      nullable = false,
      unique = true,
      length = 16,
      columnDefinition = "VARCHAR(16) COMMENT '高德城市编码'")
  private String amapCode;

  @ApiModelProperty("高德城市名称")
  @Column(
      name = "amap_name",
      nullable = false,
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '高德城市名称'")
  private String amapName;

  @ApiModelProperty("高德城市级别")
  @Column(name = "region_level", columnDefinition = "INT COMMENT '高德城市级别'")
  private Integer regionLevel;

  @ApiModelProperty("上级高德城市编码")
  @Column(name = "parent_code", length = 16, columnDefinition = "VARCHAR(16) COMMENT '上级高德城市编码'")
  private String parentCode;

  @ApiModelProperty("CRM行政区域编码")
  @Column(name = "region_code", length = 16, columnDefinition = "VARCHAR(16) COMMENT 'CRM行政区域编码'")
  private String regionCode;

  @ApiModelProperty("城市区号")
  @Column(name = "short_city_code", length = 16, columnDefinition = "VARCHAR(16) COMMENT '城市区号'")
  private String shortCityCode;

  @ApiModelProperty("高德城市名称拼音")
  @Column(name = "amap_pinyin", length = 64, columnDefinition = "VARCHAR(64) COMMENT '高德城市名称拼音'")
  private String amapPinyin;

  @ApiModelProperty("中心经度")
  @Column(name = "center_longitude", columnDefinition = "decimal(12,8) COMMENT '中心经度'")
  private BigDecimal centerLongitude;

  @ApiModelProperty("中心纬度")
  @Column(name = "center_latitude", columnDefinition = "decimal(12,8) COMMENT '中心纬度'")
  private BigDecimal centerLatitude;

  @ApiModelProperty("降维编码")
  @Column(name = "rule_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '降维编码'")
  private String ruleCode;
}
