package com.biz.crm.mdm.business.poi.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.poi.local.repository.AmapPoiRepository;
import com.biz.crm.mdm.business.poi.local.service.AmapPoiService;
import com.biz.crm.mdm.business.poi.sdk.dto.PoiDto;
import com.biz.crm.mdm.business.poi.sdk.vo.PoiVo;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 高德poi
 *
 * @author sunx
 * @date 2021/10/9
 */
@Service(value = "amapPoiService")
public class AmapPoiServiceImpl implements AmapPoiService {

  @Autowired(required = false) private AmapPoiRepository amapPoiRepository;

  @Override
  public Page<PoiVo> findByConditions(Pageable pageable, PoiDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new PoiDto());
    Page<PoiVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return amapPoiRepository.findByConditions(page, dto);
  }
}
