package com.biz.crm.mdm.business.poi.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * poi城市返回vo
 *
 * @author sunx
 * @date 2021/10/9
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "poi城市返回vo")
public class PoiCityVo extends TenantVo {

  @ApiModelProperty("城市编码")
  private String amapCode;

  @ApiModelProperty("城市名称")
  private String amapName;

  @ApiModelProperty("城市级别")
  private Integer regionLevel;

  @ApiModelProperty("上级城市编码,如果是顶层城市，该值必须为空字符串")
  private String parentCode;

  @ApiModelProperty("CRM行政区域编码")
  private String regionCode;

  @ApiModelProperty("CRM行政区域名称")
  private String regionName;

  @ApiModelProperty("城市区号")
  private String shortCityCode;

  @ApiModelProperty("城市名称拼音")
  private String amapPinyin;

  @ApiModelProperty("中心经度")
  private BigDecimal centerLongitude;

  @ApiModelProperty("中心纬度")
  private BigDecimal centerLatitude;

  @ApiModelProperty("降维编码")
  private String ruleCode;

  @ApiModelProperty(value = "是否有子节点,如果该值为空则无子节点", hidden = true)
  private String childFlag;

  @ApiModelProperty("是否有子节点 1是 0否")
  private Integer hasChildFlag;

  @ApiModelProperty("是否有子节点 true是 false否")
  private Boolean hasChild;
}
