package com.biz.crm.mdm.business.position.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.position.feign.feign.internal.PositionVoFeignImpl;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 职位基本信息feign
 *
 * @author pengxi
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = PositionVoFeignImpl.class)
public interface PositionVoFeign {

  /**
   * 根据职位id或者code集合查询职位列表
   *
   * @param ids           职位ID集合
   * @param positionCodes 职位编码集合
   * @return 职位列表
   */
  @ApiOperation(value = "根据职位id或者code集合查询职位列表")
  @GetMapping("/v1/position/position/findByIdsOrCodes")
  Result<List<PositionVo>> findByIdsOrCodes(@RequestParam(value = "ids") @ApiParam(name = "ids", value = "职位ID集合") List<String> ids
      , @RequestParam(value = "positionCodes") @ApiParam(name = "positionCodes", value = "职位编码集合") List<String> positionCodes);

  /**
   * 根据大量职位code查询职位列表
   *
   * @param positionCodes 职位编码集合
   * @return 职位列表
   */
  @ApiOperation(value = "根据大量职位code查询职位列表")
  @PostMapping("/v1/position/position/findByLotPositionCodes")
   Result<List<PositionVo>> findByLotPositionCodes(@RequestBody List<String> positionCodes);


  /**
   * 根据职位编码查询该职位的所有下级职位(包含自身)
   *
   * @param positionCode 职位编码
   * @return 所有下级职位
   */
  @ApiOperation(value = "根据职位编码查询该职位的所有下级职位(包含自身)")
  @GetMapping("/v1/position/position/findAllChildrenByCode")
  Result<List<PositionVo>> findAllChildrenByCode(@RequestParam(value = "positionCode") @ApiParam(name = "positionCode", value = "职位编码") String positionCode);

  /**
   * 根据职位编码查询该职位的直属下级
   *
   * @param positionCode 职位编码
   * @return 直属下级职位
   */
  @ApiOperation(value = "根据职位编码查询该职位的直属下级")
  @GetMapping("/v1/position/position/findByParentCode")
  Result<List<PositionVo>> findByParentCode(@RequestParam(value = "positionCode") @ApiParam(name = "positionCode", value = "职位编码") String positionCode);

  /**
   * 根据职位编码查询角色编码集合
   *
   * @param positionCodes 职位编码集合
   * @return 角色编码集合
   */
  @ApiOperation(value = "根据职位编码查询角色编码集合")
  @GetMapping("/v1/position/position/findRolesByPositionCodes")
  Result<Set<String>> findRolesByPositionCodes(@RequestParam(value = "positionCodes") @ApiParam(name = "positionCodes", value = "职位编码集合") List<String> positionCodes);
}