package com.biz.crm.mdm.business.position.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.position.feign.feign.PositionVoFeign;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 职位基本信息feign熔断实现
 *
 * @author pengxi
 */
@Component
public class PositionVoFeignImpl implements FallbackFactory<PositionVoFeign> {

  @Override
  public PositionVoFeign create(Throwable throwable) {
    return new PositionVoFeign() {

      @Override
      public Result<List<PositionVo>> findByIdsOrCodes(List<String> ids, List<String> positionCodes) {
        throw new UnsupportedOperationException("根据职位id或者code集合查询职位列表熔断");
      }

      @Override
      public Result<List<PositionVo>> findByLotPositionCodes(List<String> positionCodes) {
        throw new UnsupportedOperationException("根据大量职位code查询职位列表");
      }

      @Override
      public Result<List<PositionVo>> findAllChildrenByCode(String positionCode) {
        throw new UnsupportedOperationException("根据职位编码查询该职位的所有下级职位(包含自身)熔断");
      }

      @Override
      public Result<List<PositionVo>> findByParentCode(String positionCode) {
        throw new UnsupportedOperationException("根据职位编码查询该职位的直属下级");
      }

      @Override
      public Result<Set<String>> findRolesByPositionCodes(List<String> positionCodes) {
        throw new UnsupportedOperationException("根据职位编码集合查询角色集合熔断");
      }
    };
  }
}
