package com.biz.crm.mdm.business.position.level.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.position.level.feign.feign.PositionLevelVoServiceFeign;
import com.biz.crm.mdm.business.position.level.sdk.dto.PositionLevelDto;
import com.biz.crm.mdm.business.position.level.sdk.vo.PositionLevelVo;
import feign.hystrix.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 职位级别管理feign熔断实现
 *
 * @author ning.zhang
 * @date 2022/5/6
 */
@Component
public class PositionLevelVoServiceFeignImpl implements FallbackFactory<PositionLevelVoServiceFeign> {

  @Override
  public PositionLevelVoServiceFeign create(Throwable throwable) {

    return new PositionLevelVoServiceFeign() {
      @Override
      public Result<Page<PositionLevelVo>> findByConditions(Integer page, Integer size, PositionLevelDto dto) {
        throw new UnsupportedOperationException("职位级别分页列表熔断");
      }

      @Override
      public Result<PositionLevelVo> findById(String id) {
        throw new UnsupportedOperationException("根据id查询编辑职位级别详情熔断");
      }

      @Override
      public Result<List<PositionLevelVo>> findByIdsOrCodes(List<String> ids, List<String> positionLevelCodes) {
        throw new UnsupportedOperationException("根据职位级别ID集合或者code集合查询职位级别列表熔断");
      }
    };
  }
}
